/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import com.azure.resourcemanager.iotfirmwaredefense.models.SummaryResourceProperties;
import com.azure.resourcemanager.iotfirmwaredefense.models.SummaryType;
import java.io.IOException;

public final class CveSummary
extends SummaryResourceProperties {
    private SummaryType summaryType = SummaryType.COMMON_VULNERABILITIES_AND_EXPOSURES;
    private Long criticalCveCount;
    private Long highCveCount;
    private Long mediumCveCount;
    private Long lowCveCount;
    private Long unknownCveCount;

    private CveSummary() {
    }

    @Override
    public SummaryType summaryType() {
        return this.summaryType;
    }

    public Long criticalCveCount() {
        return this.criticalCveCount;
    }

    public Long highCveCount() {
        return this.highCveCount;
    }

    public Long mediumCveCount() {
        return this.mediumCveCount;
    }

    public Long lowCveCount() {
        return this.lowCveCount;
    }

    public Long unknownCveCount() {
        return this.unknownCveCount;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("summaryType", this.summaryType == null ? null : this.summaryType.toString());
        jsonWriter.writeNumberField("criticalCveCount", (Number)this.criticalCveCount);
        jsonWriter.writeNumberField("highCveCount", (Number)this.highCveCount);
        jsonWriter.writeNumberField("mediumCveCount", (Number)this.mediumCveCount);
        jsonWriter.writeNumberField("lowCveCount", (Number)this.lowCveCount);
        jsonWriter.writeNumberField("unknownCveCount", (Number)this.unknownCveCount);
        return jsonWriter.writeEndObject();
    }

    public static CveSummary fromJson(JsonReader jsonReader) throws IOException {
        return (CveSummary)jsonReader.readObject(reader -> {
            CveSummary deserializedCveSummary = new CveSummary();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedCveSummary.withProvisioningState(ProvisioningState.fromString(reader.getString()));
                    continue;
                }
                if ("summaryType".equals(fieldName)) {
                    deserializedCveSummary.summaryType = SummaryType.fromString(reader.getString());
                    continue;
                }
                if ("criticalCveCount".equals(fieldName)) {
                    deserializedCveSummary.criticalCveCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("highCveCount".equals(fieldName)) {
                    deserializedCveSummary.highCveCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("mediumCveCount".equals(fieldName)) {
                    deserializedCveSummary.mediumCveCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("lowCveCount".equals(fieldName)) {
                    deserializedCveSummary.lowCveCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("unknownCveCount".equals(fieldName)) {
                    deserializedCveSummary.unknownCveCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCveSummary;
        });
    }
}

