/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import com.azure.resourcemanager.iotfirmwaredefense.models.SummaryResourceProperties;
import com.azure.resourcemanager.iotfirmwaredefense.models.SummaryType;
import java.io.IOException;

public final class CryptoCertificateSummaryResource
extends SummaryResourceProperties {
    private SummaryType summaryType = SummaryType.CRYPTO_CERTIFICATE;
    private Long totalCertificateCount;
    private Long pairedKeyCount;
    private Long expiredCertificateCount;
    private Long expiringSoonCertificateCount;
    private Long weakSignatureCount;
    private Long selfSignedCertificateCount;
    private Long shortKeySizeCount;

    private CryptoCertificateSummaryResource() {
    }

    @Override
    public SummaryType summaryType() {
        return this.summaryType;
    }

    public Long totalCertificateCount() {
        return this.totalCertificateCount;
    }

    public Long pairedKeyCount() {
        return this.pairedKeyCount;
    }

    public Long expiredCertificateCount() {
        return this.expiredCertificateCount;
    }

    public Long expiringSoonCertificateCount() {
        return this.expiringSoonCertificateCount;
    }

    public Long weakSignatureCount() {
        return this.weakSignatureCount;
    }

    public Long selfSignedCertificateCount() {
        return this.selfSignedCertificateCount;
    }

    public Long shortKeySizeCount() {
        return this.shortKeySizeCount;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("summaryType", this.summaryType == null ? null : this.summaryType.toString());
        jsonWriter.writeNumberField("totalCertificateCount", (Number)this.totalCertificateCount);
        jsonWriter.writeNumberField("pairedKeyCount", (Number)this.pairedKeyCount);
        jsonWriter.writeNumberField("expiredCertificateCount", (Number)this.expiredCertificateCount);
        jsonWriter.writeNumberField("expiringSoonCertificateCount", (Number)this.expiringSoonCertificateCount);
        jsonWriter.writeNumberField("weakSignatureCount", (Number)this.weakSignatureCount);
        jsonWriter.writeNumberField("selfSignedCertificateCount", (Number)this.selfSignedCertificateCount);
        jsonWriter.writeNumberField("shortKeySizeCount", (Number)this.shortKeySizeCount);
        return jsonWriter.writeEndObject();
    }

    public static CryptoCertificateSummaryResource fromJson(JsonReader jsonReader) throws IOException {
        return (CryptoCertificateSummaryResource)jsonReader.readObject(reader -> {
            CryptoCertificateSummaryResource deserializedCryptoCertificateSummaryResource = new CryptoCertificateSummaryResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedCryptoCertificateSummaryResource.withProvisioningState(ProvisioningState.fromString(reader.getString()));
                    continue;
                }
                if ("summaryType".equals(fieldName)) {
                    deserializedCryptoCertificateSummaryResource.summaryType = SummaryType.fromString(reader.getString());
                    continue;
                }
                if ("totalCertificateCount".equals(fieldName)) {
                    deserializedCryptoCertificateSummaryResource.totalCertificateCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("pairedKeyCount".equals(fieldName)) {
                    deserializedCryptoCertificateSummaryResource.pairedKeyCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("expiredCertificateCount".equals(fieldName)) {
                    deserializedCryptoCertificateSummaryResource.expiredCertificateCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("expiringSoonCertificateCount".equals(fieldName)) {
                    deserializedCryptoCertificateSummaryResource.expiringSoonCertificateCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("weakSignatureCount".equals(fieldName)) {
                    deserializedCryptoCertificateSummaryResource.weakSignatureCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("selfSignedCertificateCount".equals(fieldName)) {
                    deserializedCryptoCertificateSummaryResource.selfSignedCertificateCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("shortKeySizeCount".equals(fieldName)) {
                    deserializedCryptoCertificateSummaryResource.shortKeySizeCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCryptoCertificateSummaryResource;
        });
    }
}

