/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import com.azure.resourcemanager.iotfirmwaredefense.models.SummaryResourceProperties;
import com.azure.resourcemanager.iotfirmwaredefense.models.SummaryType;
import java.io.IOException;

public final class BinaryHardeningSummaryResource
extends SummaryResourceProperties {
    private SummaryType summaryType = SummaryType.BINARY_HARDENING;
    private Long totalFiles;
    private Long notExecutableStackCount;
    private Long positionIndependentExecutableCount;
    private Long relocationReadOnlyCount;
    private Long stackCanaryCount;
    private Long strippedBinaryCount;

    private BinaryHardeningSummaryResource() {
    }

    @Override
    public SummaryType summaryType() {
        return this.summaryType;
    }

    public Long totalFiles() {
        return this.totalFiles;
    }

    public Long notExecutableStackCount() {
        return this.notExecutableStackCount;
    }

    public Long positionIndependentExecutableCount() {
        return this.positionIndependentExecutableCount;
    }

    public Long relocationReadOnlyCount() {
        return this.relocationReadOnlyCount;
    }

    public Long stackCanaryCount() {
        return this.stackCanaryCount;
    }

    public Long strippedBinaryCount() {
        return this.strippedBinaryCount;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("summaryType", this.summaryType == null ? null : this.summaryType.toString());
        jsonWriter.writeNumberField("totalFiles", (Number)this.totalFiles);
        jsonWriter.writeNumberField("notExecutableStackCount", (Number)this.notExecutableStackCount);
        jsonWriter.writeNumberField("positionIndependentExecutableCount", (Number)this.positionIndependentExecutableCount);
        jsonWriter.writeNumberField("relocationReadOnlyCount", (Number)this.relocationReadOnlyCount);
        jsonWriter.writeNumberField("stackCanaryCount", (Number)this.stackCanaryCount);
        jsonWriter.writeNumberField("strippedBinaryCount", (Number)this.strippedBinaryCount);
        return jsonWriter.writeEndObject();
    }

    public static BinaryHardeningSummaryResource fromJson(JsonReader jsonReader) throws IOException {
        return (BinaryHardeningSummaryResource)jsonReader.readObject(reader -> {
            BinaryHardeningSummaryResource deserializedBinaryHardeningSummaryResource = new BinaryHardeningSummaryResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedBinaryHardeningSummaryResource.withProvisioningState(ProvisioningState.fromString(reader.getString()));
                    continue;
                }
                if ("summaryType".equals(fieldName)) {
                    deserializedBinaryHardeningSummaryResource.summaryType = SummaryType.fromString(reader.getString());
                    continue;
                }
                if ("totalFiles".equals(fieldName)) {
                    deserializedBinaryHardeningSummaryResource.totalFiles = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("notExecutableStackCount".equals(fieldName)) {
                    deserializedBinaryHardeningSummaryResource.notExecutableStackCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("positionIndependentExecutableCount".equals(fieldName)) {
                    deserializedBinaryHardeningSummaryResource.positionIndependentExecutableCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("relocationReadOnlyCount".equals(fieldName)) {
                    deserializedBinaryHardeningSummaryResource.relocationReadOnlyCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("stackCanaryCount".equals(fieldName)) {
                    deserializedBinaryHardeningSummaryResource.stackCanaryCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("strippedBinaryCount".equals(fieldName)) {
                    deserializedBinaryHardeningSummaryResource.strippedBinaryCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBinaryHardeningSummaryResource;
        });
    }
}

