/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.SbomComponentResourceInner;
import java.io.IOException;
import java.util.List;

public final class SbomComponentResourceListResult
implements JsonSerializable<SbomComponentResourceListResult> {
    private List<SbomComponentResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(SbomComponentResourceListResult.class);

    private SbomComponentResourceListResult() {
    }

    public List<SbomComponentResourceInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SbomComponentResourceListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static SbomComponentResourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (SbomComponentResourceListResult)jsonReader.readObject(reader -> {
            SbomComponentResourceListResult deserializedSbomComponentResourceListResult = new SbomComponentResourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSbomComponentResourceListResult.value = value = reader.readArray(reader1 -> SbomComponentResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSbomComponentResourceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSbomComponentResourceListResult;
        });
    }
}

