/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.PasswordHashResourceInner;
import java.io.IOException;
import java.util.List;

public final class PasswordHashResourceListResult
implements JsonSerializable<PasswordHashResourceListResult> {
    private List<PasswordHashResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(PasswordHashResourceListResult.class);

    private PasswordHashResourceListResult() {
    }

    public List<PasswordHashResourceInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model PasswordHashResourceListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static PasswordHashResourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (PasswordHashResourceListResult)jsonReader.readObject(reader -> {
            PasswordHashResourceListResult deserializedPasswordHashResourceListResult = new PasswordHashResourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedPasswordHashResourceListResult.value = value = reader.readArray(reader1 -> PasswordHashResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedPasswordHashResourceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPasswordHashResourceListResult;
        });
    }
}

