/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.FirmwareInner;
import java.io.IOException;
import java.util.List;

public final class FirmwareListResult
implements JsonSerializable<FirmwareListResult> {
    private List<FirmwareInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(FirmwareListResult.class);

    private FirmwareListResult() {
    }

    public List<FirmwareInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model FirmwareListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static FirmwareListResult fromJson(JsonReader jsonReader) throws IOException {
        return (FirmwareListResult)jsonReader.readObject(reader -> {
            FirmwareListResult deserializedFirmwareListResult = new FirmwareListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedFirmwareListResult.value = value = reader.readArray(reader1 -> FirmwareInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedFirmwareListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFirmwareListResult;
        });
    }
}

