/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.CryptoKeyResourceInner;
import java.io.IOException;
import java.util.List;

public final class CryptoKeyResourceListResult
implements JsonSerializable<CryptoKeyResourceListResult> {
    private List<CryptoKeyResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(CryptoKeyResourceListResult.class);

    private CryptoKeyResourceListResult() {
    }

    public List<CryptoKeyResourceInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model CryptoKeyResourceListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static CryptoKeyResourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (CryptoKeyResourceListResult)jsonReader.readObject(reader -> {
            CryptoKeyResourceListResult deserializedCryptoKeyResourceListResult = new CryptoKeyResourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedCryptoKeyResourceListResult.value = value = reader.readArray(reader1 -> CryptoKeyResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedCryptoKeyResourceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCryptoKeyResourceListResult;
        });
    }
}

