/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.iotfirmwaredefense.IoTFirmwareDefenseManager;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.WorkspaceInner;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.iotfirmwaredefense.models.GenerateUploadUrlRequest;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import com.azure.resourcemanager.iotfirmwaredefense.models.Sku;
import com.azure.resourcemanager.iotfirmwaredefense.models.UrlToken;
import com.azure.resourcemanager.iotfirmwaredefense.models.Workspace;
import com.azure.resourcemanager.iotfirmwaredefense.models.WorkspaceUpdate;
import java.util.Collections;
import java.util.Map;

public final class WorkspaceImpl
implements Workspace,
Workspace.Definition,
Workspace.Update {
    private WorkspaceInner innerObject;
    private final IoTFirmwareDefenseManager serviceManager;
    private String resourceGroupName;
    private String workspaceName;
    private WorkspaceUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public Sku sku() {
        return this.innerModel().sku();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public WorkspaceInner innerModel() {
        return this.innerObject;
    }

    private IoTFirmwareDefenseManager manager() {
        return this.serviceManager;
    }

    @Override
    public WorkspaceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Workspace create() {
        this.innerObject = (WorkspaceInner)((Object)this.serviceManager.serviceClient().getWorkspaces().createWithResponse(this.resourceGroupName, this.workspaceName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Workspace create(Context context) {
        this.innerObject = (WorkspaceInner)((Object)this.serviceManager.serviceClient().getWorkspaces().createWithResponse(this.resourceGroupName, this.workspaceName, this.innerModel(), context).getValue());
        return this;
    }

    WorkspaceImpl(String name, IoTFirmwareDefenseManager serviceManager) {
        this.innerObject = new WorkspaceInner();
        this.serviceManager = serviceManager;
        this.workspaceName = name;
    }

    @Override
    public WorkspaceImpl update() {
        this.updateProperties = new WorkspaceUpdate();
        return this;
    }

    @Override
    public Workspace apply() {
        this.innerObject = (WorkspaceInner)((Object)this.serviceManager.serviceClient().getWorkspaces().updateWithResponse(this.resourceGroupName, this.workspaceName, this.updateProperties, Context.NONE).getValue());
        return this;
    }

    @Override
    public Workspace apply(Context context) {
        this.innerObject = (WorkspaceInner)((Object)this.serviceManager.serviceClient().getWorkspaces().updateWithResponse(this.resourceGroupName, this.workspaceName, this.updateProperties, context).getValue());
        return this;
    }

    WorkspaceImpl(WorkspaceInner innerObject, IoTFirmwareDefenseManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.workspaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workspaces");
    }

    @Override
    public Workspace refresh() {
        this.innerObject = (WorkspaceInner)((Object)this.serviceManager.serviceClient().getWorkspaces().getByResourceGroupWithResponse(this.resourceGroupName, this.workspaceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Workspace refresh(Context context) {
        this.innerObject = (WorkspaceInner)((Object)this.serviceManager.serviceClient().getWorkspaces().getByResourceGroupWithResponse(this.resourceGroupName, this.workspaceName, context).getValue());
        return this;
    }

    @Override
    public Response<UrlToken> generateUploadUrlWithResponse(GenerateUploadUrlRequest body, Context context) {
        return this.serviceManager.workspaces().generateUploadUrlWithResponse(this.resourceGroupName, this.workspaceName, body, context);
    }

    @Override
    public UrlToken generateUploadUrl(GenerateUploadUrlRequest body) {
        return this.serviceManager.workspaces().generateUploadUrl(this.resourceGroupName, this.workspaceName, body);
    }

    @Override
    public WorkspaceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public WorkspaceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public WorkspaceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public WorkspaceImpl withSku(Sku sku) {
        if (this.isInCreateMode()) {
            this.innerModel().withSku(sku);
            return this;
        }
        this.updateProperties.withSku(sku);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

