/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iotfirmwaredefense.IoTFirmwareDefenseManager;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.UsageMetricsClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.UsageMetricInner;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.UsageMetricImpl;
import com.azure.resourcemanager.iotfirmwaredefense.models.UsageMetric;
import com.azure.resourcemanager.iotfirmwaredefense.models.UsageMetrics;

public final class UsageMetricsImpl
implements UsageMetrics {
    private static final ClientLogger LOGGER = new ClientLogger(UsageMetricsImpl.class);
    private final UsageMetricsClient innerClient;
    private final IoTFirmwareDefenseManager serviceManager;

    public UsageMetricsImpl(UsageMetricsClient innerClient, IoTFirmwareDefenseManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<UsageMetric> getWithResponse(String resourceGroupName, String workspaceName, String name, Context context) {
        Response<UsageMetricInner> inner = this.serviceClient().getWithResponse(resourceGroupName, workspaceName, name, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new UsageMetricImpl((UsageMetricInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public UsageMetric get(String resourceGroupName, String workspaceName, String name) {
        UsageMetricInner inner = this.serviceClient().get(resourceGroupName, workspaceName, name);
        if (inner != null) {
            return new UsageMetricImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<UsageMetric> listByWorkspace(String resourceGroupName, String workspaceName) {
        PagedIterable<UsageMetricInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, workspaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UsageMetricImpl((UsageMetricInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<UsageMetric> listByWorkspace(String resourceGroupName, String workspaceName, Context context) {
        PagedIterable<UsageMetricInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, workspaceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UsageMetricImpl((UsageMetricInner)((Object)inner1), this.manager()));
    }

    private UsageMetricsClient serviceClient() {
        return this.innerClient;
    }

    private IoTFirmwareDefenseManager manager() {
        return this.serviceManager;
    }
}

