/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.management.polling.SyncPollerFactory;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.BinaryHardeningsClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.CryptoCertificatesClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.CryptoKeysClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.CvesClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.FirmwaresClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.IoTFirmwareDefenseMgmtClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.OperationsClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.PasswordHashesClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.SbomComponentsClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.SummariesClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.UsageMetricsClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.WorkspacesClient;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.BinaryHardeningsClientImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.CryptoCertificatesClientImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.CryptoKeysClientImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.CvesClientImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.FirmwaresClientImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.IoTFirmwareDefenseMgmtClientBuilder;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.OperationsClientImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.PasswordHashesClientImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.SbomComponentsClientImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.SummariesClientImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.UsageMetricsClientImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.WorkspacesClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=IoTFirmwareDefenseMgmtClientBuilder.class)
public final class IoTFirmwareDefenseMgmtClientImpl
implements IoTFirmwareDefenseMgmtClient {
    private final String endpoint;
    private final String apiVersion;
    private final String subscriptionId;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final OperationsClient operations;
    private final FirmwaresClient firmwares;
    private final WorkspacesClient workspaces;
    private final BinaryHardeningsClient binaryHardenings;
    private final CryptoCertificatesClient cryptoCertificates;
    private final CryptoKeysClient cryptoKeys;
    private final CvesClient cves;
    private final PasswordHashesClient passwordHashes;
    private final SbomComponentsClient sbomComponents;
    private final SummariesClient summaries;
    private final UsageMetricsClient usageMetrics;
    private static final ClientLogger LOGGER = new ClientLogger(IoTFirmwareDefenseMgmtClientImpl.class);

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public FirmwaresClient getFirmwares() {
        return this.firmwares;
    }

    @Override
    public WorkspacesClient getWorkspaces() {
        return this.workspaces;
    }

    @Override
    public BinaryHardeningsClient getBinaryHardenings() {
        return this.binaryHardenings;
    }

    @Override
    public CryptoCertificatesClient getCryptoCertificates() {
        return this.cryptoCertificates;
    }

    @Override
    public CryptoKeysClient getCryptoKeys() {
        return this.cryptoKeys;
    }

    @Override
    public CvesClient getCves() {
        return this.cves;
    }

    @Override
    public PasswordHashesClient getPasswordHashes() {
        return this.passwordHashes;
    }

    @Override
    public SbomComponentsClient getSbomComponents() {
        return this.sbomComponents;
    }

    @Override
    public SummariesClient getSummaries() {
        return this.summaries;
    }

    @Override
    public UsageMetricsClient getUsageMetrics() {
        return this.usageMetrics;
    }

    IoTFirmwareDefenseMgmtClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String endpoint, String subscriptionId) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.endpoint = endpoint;
        this.subscriptionId = subscriptionId;
        this.apiVersion = "2025-08-02";
        this.operations = new OperationsClientImpl(this);
        this.firmwares = new FirmwaresClientImpl(this);
        this.workspaces = new WorkspacesClientImpl(this);
        this.binaryHardenings = new BinaryHardeningsClientImpl(this);
        this.cryptoCertificates = new CryptoCertificatesClientImpl(this);
        this.cryptoKeys = new CryptoKeysClientImpl(this);
        this.cves = new CvesClientImpl(this);
        this.passwordHashes = new PasswordHashesClientImpl(this);
        this.sbomComponents = new SbomComponentsClientImpl(this);
        this.summaries = new SummariesClientImpl(this);
        this.usageMetrics = new UsageMetricsClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> SyncPoller<PollResult<T>, U> getLroResult(Response<BinaryData> activationResponse, Type pollResultType, Type finalResultType, Context context) {
        return SyncPollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)this.httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, () -> activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

