/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.iotfirmwaredefense.IoTFirmwareDefenseManager;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.FirmwareInner;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.iotfirmwaredefense.models.Firmware;
import com.azure.resourcemanager.iotfirmwaredefense.models.FirmwareUpdateDefinition;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import com.azure.resourcemanager.iotfirmwaredefense.models.Status;
import com.azure.resourcemanager.iotfirmwaredefense.models.StatusMessage;
import java.util.Collections;
import java.util.List;

public final class FirmwareImpl
implements Firmware,
Firmware.Definition,
Firmware.Update {
    private FirmwareInner innerObject;
    private final IoTFirmwareDefenseManager serviceManager;
    private String resourceGroupName;
    private String workspaceName;
    private String firmwareId;
    private FirmwareUpdateDefinition updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String fileName() {
        return this.innerModel().fileName();
    }

    @Override
    public String vendor() {
        return this.innerModel().vendor();
    }

    @Override
    public String model() {
        return this.innerModel().model();
    }

    @Override
    public String version() {
        return this.innerModel().version();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public Long fileSize() {
        return this.innerModel().fileSize();
    }

    @Override
    public Status status() {
        return this.innerModel().status();
    }

    @Override
    public List<StatusMessage> statusMessages() {
        List<StatusMessage> inner = this.innerModel().statusMessages();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public FirmwareInner innerModel() {
        return this.innerObject;
    }

    private IoTFirmwareDefenseManager manager() {
        return this.serviceManager;
    }

    @Override
    public FirmwareImpl withExistingWorkspace(String resourceGroupName, String workspaceName) {
        this.resourceGroupName = resourceGroupName;
        this.workspaceName = workspaceName;
        return this;
    }

    @Override
    public Firmware create() {
        this.innerObject = (FirmwareInner)((Object)this.serviceManager.serviceClient().getFirmwares().createWithResponse(this.resourceGroupName, this.workspaceName, this.firmwareId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Firmware create(Context context) {
        this.innerObject = (FirmwareInner)((Object)this.serviceManager.serviceClient().getFirmwares().createWithResponse(this.resourceGroupName, this.workspaceName, this.firmwareId, this.innerModel(), context).getValue());
        return this;
    }

    FirmwareImpl(String name, IoTFirmwareDefenseManager serviceManager) {
        this.innerObject = new FirmwareInner();
        this.serviceManager = serviceManager;
        this.firmwareId = name;
    }

    @Override
    public FirmwareImpl update() {
        this.updateProperties = new FirmwareUpdateDefinition();
        return this;
    }

    @Override
    public Firmware apply() {
        this.innerObject = (FirmwareInner)((Object)this.serviceManager.serviceClient().getFirmwares().updateWithResponse(this.resourceGroupName, this.workspaceName, this.firmwareId, this.updateProperties, Context.NONE).getValue());
        return this;
    }

    @Override
    public Firmware apply(Context context) {
        this.innerObject = (FirmwareInner)((Object)this.serviceManager.serviceClient().getFirmwares().updateWithResponse(this.resourceGroupName, this.workspaceName, this.firmwareId, this.updateProperties, context).getValue());
        return this;
    }

    FirmwareImpl(FirmwareInner innerObject, IoTFirmwareDefenseManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.workspaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "workspaces");
        this.firmwareId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "firmwares");
    }

    @Override
    public Firmware refresh() {
        this.innerObject = (FirmwareInner)((Object)this.serviceManager.serviceClient().getFirmwares().getWithResponse(this.resourceGroupName, this.workspaceName, this.firmwareId, Context.NONE).getValue());
        return this;
    }

    @Override
    public Firmware refresh(Context context) {
        this.innerObject = (FirmwareInner)((Object)this.serviceManager.serviceClient().getFirmwares().getWithResponse(this.resourceGroupName, this.workspaceName, this.firmwareId, context).getValue());
        return this;
    }

    @Override
    public FirmwareImpl withFileName(String fileName) {
        if (this.isInCreateMode()) {
            this.innerModel().withFileName(fileName);
            return this;
        }
        this.updateProperties.withFileName(fileName);
        return this;
    }

    @Override
    public FirmwareImpl withVendor(String vendor) {
        if (this.isInCreateMode()) {
            this.innerModel().withVendor(vendor);
            return this;
        }
        this.updateProperties.withVendor(vendor);
        return this;
    }

    @Override
    public FirmwareImpl withModel(String model) {
        if (this.isInCreateMode()) {
            this.innerModel().withModel(model);
            return this;
        }
        this.updateProperties.withModel(model);
        return this;
    }

    @Override
    public FirmwareImpl withVersion(String version) {
        if (this.isInCreateMode()) {
            this.innerModel().withVersion(version);
            return this;
        }
        this.updateProperties.withVersion(version);
        return this;
    }

    @Override
    public FirmwareImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        }
        this.updateProperties.withDescription(description);
        return this;
    }

    @Override
    public FirmwareImpl withFileSize(Long fileSize) {
        if (this.isInCreateMode()) {
            this.innerModel().withFileSize(fileSize);
            return this;
        }
        this.updateProperties.withFileSize(fileSize);
        return this;
    }

    @Override
    public FirmwareImpl withStatus(Status status) {
        if (this.isInCreateMode()) {
            this.innerModel().withStatus(status);
            return this;
        }
        this.updateProperties.withStatus(status);
        return this;
    }

    @Override
    public FirmwareImpl withStatusMessages(List<StatusMessage> statusMessages) {
        if (this.isInCreateMode()) {
            this.innerModel().withStatusMessages(statusMessages);
            return this;
        }
        this.updateProperties.withStatusMessages(statusMessages);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

