/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iotfirmwaredefense.IoTFirmwareDefenseManager;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.CvesClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.CveResourceInner;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.CveResourceImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.iotfirmwaredefense.models.CveResource;
import com.azure.resourcemanager.iotfirmwaredefense.models.Cves;

public final class CvesImpl
implements Cves {
    private static final ClientLogger LOGGER = new ClientLogger(CvesImpl.class);
    private final CvesClient innerClient;
    private final IoTFirmwareDefenseManager serviceManager;

    public CvesImpl(CvesClient innerClient, IoTFirmwareDefenseManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<CveResource> listByFirmware(String resourceGroupName, String workspaceName, String firmwareId) {
        PagedIterable<CveResourceInner> inner = this.serviceClient().listByFirmware(resourceGroupName, workspaceName, firmwareId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CveResourceImpl((CveResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CveResource> listByFirmware(String resourceGroupName, String workspaceName, String firmwareId, Context context) {
        PagedIterable<CveResourceInner> inner = this.serviceClient().listByFirmware(resourceGroupName, workspaceName, firmwareId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CveResourceImpl((CveResourceInner)((Object)inner1), this.manager()));
    }

    private CvesClient serviceClient() {
        return this.innerClient;
    }

    private IoTFirmwareDefenseManager manager() {
        return this.serviceManager;
    }
}

