/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iotfirmwaredefense.IoTFirmwareDefenseManager;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.CryptoCertificatesClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.CryptoCertificateResourceInner;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.CryptoCertificateResourceImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.iotfirmwaredefense.models.CryptoCertificateResource;
import com.azure.resourcemanager.iotfirmwaredefense.models.CryptoCertificates;

public final class CryptoCertificatesImpl
implements CryptoCertificates {
    private static final ClientLogger LOGGER = new ClientLogger(CryptoCertificatesImpl.class);
    private final CryptoCertificatesClient innerClient;
    private final IoTFirmwareDefenseManager serviceManager;

    public CryptoCertificatesImpl(CryptoCertificatesClient innerClient, IoTFirmwareDefenseManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<CryptoCertificateResource> listByFirmware(String resourceGroupName, String workspaceName, String firmwareId) {
        PagedIterable<CryptoCertificateResourceInner> inner = this.serviceClient().listByFirmware(resourceGroupName, workspaceName, firmwareId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CryptoCertificateResourceImpl((CryptoCertificateResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CryptoCertificateResource> listByFirmware(String resourceGroupName, String workspaceName, String firmwareId, Context context) {
        PagedIterable<CryptoCertificateResourceInner> inner = this.serviceClient().listByFirmware(resourceGroupName, workspaceName, firmwareId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CryptoCertificateResourceImpl((CryptoCertificateResourceInner)((Object)inner1), this.manager()));
    }

    private CryptoCertificatesClient serviceClient() {
        return this.innerClient;
    }

    private IoTFirmwareDefenseManager manager() {
        return this.serviceManager;
    }
}

