/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.PasswordHash;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import java.io.IOException;

public final class PasswordHashResourceInner
extends ProxyResource {
    private PasswordHash innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private PasswordHashResourceInner() {
    }

    private PasswordHash innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String passwordHashId() {
        return this.innerProperties() == null ? null : this.innerProperties().passwordHashId();
    }

    public String filePath() {
        return this.innerProperties() == null ? null : this.innerProperties().filePath();
    }

    public String salt() {
        return this.innerProperties() == null ? null : this.innerProperties().salt();
    }

    public String hash() {
        return this.innerProperties() == null ? null : this.innerProperties().hash();
    }

    public String context() {
        return this.innerProperties() == null ? null : this.innerProperties().context();
    }

    public String username() {
        return this.innerProperties() == null ? null : this.innerProperties().username();
    }

    public String algorithm() {
        return this.innerProperties() == null ? null : this.innerProperties().algorithm();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PasswordHashResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (PasswordHashResourceInner)((Object)jsonReader.readObject(reader -> {
            PasswordHashResourceInner deserializedPasswordHashResourceInner = new PasswordHashResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPasswordHashResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPasswordHashResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPasswordHashResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPasswordHashResourceInner.innerProperties = PasswordHash.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedPasswordHashResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPasswordHashResourceInner;
        }));
    }
}

