/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import java.io.IOException;

public final class PasswordHash
implements JsonSerializable<PasswordHash> {
    private String passwordHashId;
    private String filePath;
    private String salt;
    private String hash;
    private String context;
    private String username;
    private String algorithm;
    private ProvisioningState provisioningState;

    private PasswordHash() {
    }

    public String passwordHashId() {
        return this.passwordHashId;
    }

    public String filePath() {
        return this.filePath;
    }

    public String salt() {
        return this.salt;
    }

    public String hash() {
        return this.hash;
    }

    public String context() {
        return this.context;
    }

    public String username() {
        return this.username;
    }

    public String algorithm() {
        return this.algorithm;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("passwordHashId", this.passwordHashId);
        jsonWriter.writeStringField("filePath", this.filePath);
        jsonWriter.writeStringField("salt", this.salt);
        jsonWriter.writeStringField("hash", this.hash);
        jsonWriter.writeStringField("context", this.context);
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("algorithm", this.algorithm);
        return jsonWriter.writeEndObject();
    }

    public static PasswordHash fromJson(JsonReader jsonReader) throws IOException {
        return (PasswordHash)jsonReader.readObject(reader -> {
            PasswordHash deserializedPasswordHash = new PasswordHash();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("passwordHashId".equals(fieldName)) {
                    deserializedPasswordHash.passwordHashId = reader.getString();
                    continue;
                }
                if ("filePath".equals(fieldName)) {
                    deserializedPasswordHash.filePath = reader.getString();
                    continue;
                }
                if ("salt".equals(fieldName)) {
                    deserializedPasswordHash.salt = reader.getString();
                    continue;
                }
                if ("hash".equals(fieldName)) {
                    deserializedPasswordHash.hash = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    deserializedPasswordHash.context = reader.getString();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedPasswordHash.username = reader.getString();
                    continue;
                }
                if ("algorithm".equals(fieldName)) {
                    deserializedPasswordHash.algorithm = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPasswordHash.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPasswordHash;
        });
    }
}

