/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import com.azure.resourcemanager.iotfirmwaredefense.models.Status;
import com.azure.resourcemanager.iotfirmwaredefense.models.StatusMessage;
import java.io.IOException;
import java.util.List;

public final class FirmwareProperties
implements JsonSerializable<FirmwareProperties> {
    private String fileName;
    private String vendor;
    private String model;
    private String version;
    private String description;
    private Long fileSize;
    private Status status;
    private List<StatusMessage> statusMessages;
    private ProvisioningState provisioningState;

    public String fileName() {
        return this.fileName;
    }

    public FirmwareProperties withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public String vendor() {
        return this.vendor;
    }

    public FirmwareProperties withVendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    public String model() {
        return this.model;
    }

    public FirmwareProperties withModel(String model) {
        this.model = model;
        return this;
    }

    public String version() {
        return this.version;
    }

    public FirmwareProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    public String description() {
        return this.description;
    }

    public FirmwareProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Long fileSize() {
        return this.fileSize;
    }

    public FirmwareProperties withFileSize(Long fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    public Status status() {
        return this.status;
    }

    public FirmwareProperties withStatus(Status status) {
        this.status = status;
        return this;
    }

    public List<StatusMessage> statusMessages() {
        return this.statusMessages;
    }

    public FirmwareProperties withStatusMessages(List<StatusMessage> statusMessages) {
        this.statusMessages = statusMessages;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.statusMessages() != null) {
            this.statusMessages().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fileName", this.fileName);
        jsonWriter.writeStringField("vendor", this.vendor);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeNumberField("fileSize", (Number)this.fileSize);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeArrayField("statusMessages", this.statusMessages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static FirmwareProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FirmwareProperties)jsonReader.readObject(reader -> {
            FirmwareProperties deserializedFirmwareProperties = new FirmwareProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fileName".equals(fieldName)) {
                    deserializedFirmwareProperties.fileName = reader.getString();
                    continue;
                }
                if ("vendor".equals(fieldName)) {
                    deserializedFirmwareProperties.vendor = reader.getString();
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedFirmwareProperties.model = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedFirmwareProperties.version = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedFirmwareProperties.description = reader.getString();
                    continue;
                }
                if ("fileSize".equals(fieldName)) {
                    deserializedFirmwareProperties.fileSize = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedFirmwareProperties.status = Status.fromString(reader.getString());
                    continue;
                }
                if ("statusMessages".equals(fieldName)) {
                    List statusMessages;
                    deserializedFirmwareProperties.statusMessages = statusMessages = reader.readArray(reader1 -> StatusMessage.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedFirmwareProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFirmwareProperties;
        });
    }
}

