/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.FirmwareProperties;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import com.azure.resourcemanager.iotfirmwaredefense.models.Status;
import com.azure.resourcemanager.iotfirmwaredefense.models.StatusMessage;
import java.io.IOException;
import java.util.List;

public final class FirmwareInner
extends ProxyResource {
    private FirmwareProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private FirmwareProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String fileName() {
        return this.innerProperties() == null ? null : this.innerProperties().fileName();
    }

    public FirmwareInner withFileName(String fileName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FirmwareProperties();
        }
        this.innerProperties().withFileName(fileName);
        return this;
    }

    public String vendor() {
        return this.innerProperties() == null ? null : this.innerProperties().vendor();
    }

    public FirmwareInner withVendor(String vendor) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FirmwareProperties();
        }
        this.innerProperties().withVendor(vendor);
        return this;
    }

    public String model() {
        return this.innerProperties() == null ? null : this.innerProperties().model();
    }

    public FirmwareInner withModel(String model) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FirmwareProperties();
        }
        this.innerProperties().withModel(model);
        return this;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public FirmwareInner withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FirmwareProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public FirmwareInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FirmwareProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public Long fileSize() {
        return this.innerProperties() == null ? null : this.innerProperties().fileSize();
    }

    public FirmwareInner withFileSize(Long fileSize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FirmwareProperties();
        }
        this.innerProperties().withFileSize(fileSize);
        return this;
    }

    public Status status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public FirmwareInner withStatus(Status status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FirmwareProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public List<StatusMessage> statusMessages() {
        return this.innerProperties() == null ? null : this.innerProperties().statusMessages();
    }

    public FirmwareInner withStatusMessages(List<StatusMessage> statusMessages) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FirmwareProperties();
        }
        this.innerProperties().withStatusMessages(statusMessages);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static FirmwareInner fromJson(JsonReader jsonReader) throws IOException {
        return (FirmwareInner)((Object)jsonReader.readObject(reader -> {
            FirmwareInner deserializedFirmwareInner = new FirmwareInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedFirmwareInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedFirmwareInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFirmwareInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedFirmwareInner.innerProperties = FirmwareProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedFirmwareInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFirmwareInner;
        }));
    }
}

