/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.models.CveComponent;
import com.azure.resourcemanager.iotfirmwaredefense.models.CveLink;
import com.azure.resourcemanager.iotfirmwaredefense.models.CvssScore;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class CveResult
implements JsonSerializable<CveResult> {
    private String cveId;
    private String componentId;
    private String componentName;
    private String componentVersion;
    private String severity;
    private String cveName;
    private CveComponent component;
    private String cvssScore;
    private String cvssV2Score;
    private String cvssV3Score;
    private String cvssVersion;
    private Double effectiveCvssScore;
    private Integer effectiveCvssVersion;
    private List<CvssScore> cvssScores;
    private List<CveLink> links;
    private String description;
    private ProvisioningState provisioningState;

    private CveResult() {
    }

    public String cveId() {
        return this.cveId;
    }

    public String componentId() {
        return this.componentId;
    }

    public String componentName() {
        return this.componentName;
    }

    public String componentVersion() {
        return this.componentVersion;
    }

    public String severity() {
        return this.severity;
    }

    public String cveName() {
        return this.cveName;
    }

    public CveComponent component() {
        return this.component;
    }

    public String cvssScore() {
        return this.cvssScore;
    }

    public String cvssV2Score() {
        return this.cvssV2Score;
    }

    public String cvssV3Score() {
        return this.cvssV3Score;
    }

    public String cvssVersion() {
        return this.cvssVersion;
    }

    public Double effectiveCvssScore() {
        return this.effectiveCvssScore;
    }

    public Integer effectiveCvssVersion() {
        return this.effectiveCvssVersion;
    }

    public List<CvssScore> cvssScores() {
        return this.cvssScores;
    }

    public List<CveLink> links() {
        return this.links;
    }

    public String description() {
        return this.description;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.component() != null) {
            this.component().validate();
        }
        if (this.cvssScores() != null) {
            this.cvssScores().forEach(e -> e.validate());
        }
        if (this.links() != null) {
            this.links().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("cveId", this.cveId);
        jsonWriter.writeStringField("componentId", this.componentId);
        jsonWriter.writeStringField("componentName", this.componentName);
        jsonWriter.writeStringField("componentVersion", this.componentVersion);
        jsonWriter.writeStringField("severity", this.severity);
        jsonWriter.writeStringField("cveName", this.cveName);
        jsonWriter.writeJsonField("component", (JsonSerializable)this.component);
        jsonWriter.writeStringField("cvssScore", this.cvssScore);
        jsonWriter.writeStringField("cvssV2Score", this.cvssV2Score);
        jsonWriter.writeStringField("cvssV3Score", this.cvssV3Score);
        jsonWriter.writeStringField("cvssVersion", this.cvssVersion);
        jsonWriter.writeNumberField("effectiveCvssScore", (Number)this.effectiveCvssScore);
        jsonWriter.writeNumberField("effectiveCvssVersion", (Number)this.effectiveCvssVersion);
        jsonWriter.writeArrayField("cvssScores", this.cvssScores, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static CveResult fromJson(JsonReader jsonReader) throws IOException {
        return (CveResult)jsonReader.readObject(reader -> {
            CveResult deserializedCveResult = new CveResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("cveId".equals(fieldName)) {
                    deserializedCveResult.cveId = reader.getString();
                    continue;
                }
                if ("componentId".equals(fieldName)) {
                    deserializedCveResult.componentId = reader.getString();
                    continue;
                }
                if ("componentName".equals(fieldName)) {
                    deserializedCveResult.componentName = reader.getString();
                    continue;
                }
                if ("componentVersion".equals(fieldName)) {
                    deserializedCveResult.componentVersion = reader.getString();
                    continue;
                }
                if ("severity".equals(fieldName)) {
                    deserializedCveResult.severity = reader.getString();
                    continue;
                }
                if ("cveName".equals(fieldName)) {
                    deserializedCveResult.cveName = reader.getString();
                    continue;
                }
                if ("component".equals(fieldName)) {
                    deserializedCveResult.component = CveComponent.fromJson(reader);
                    continue;
                }
                if ("cvssScore".equals(fieldName)) {
                    deserializedCveResult.cvssScore = reader.getString();
                    continue;
                }
                if ("cvssV2Score".equals(fieldName)) {
                    deserializedCveResult.cvssV2Score = reader.getString();
                    continue;
                }
                if ("cvssV3Score".equals(fieldName)) {
                    deserializedCveResult.cvssV3Score = reader.getString();
                    continue;
                }
                if ("cvssVersion".equals(fieldName)) {
                    deserializedCveResult.cvssVersion = reader.getString();
                    continue;
                }
                if ("effectiveCvssScore".equals(fieldName)) {
                    deserializedCveResult.effectiveCvssScore = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("effectiveCvssVersion".equals(fieldName)) {
                    deserializedCveResult.effectiveCvssVersion = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("cvssScores".equals(fieldName)) {
                    List cvssScores;
                    deserializedCveResult.cvssScores = cvssScores = reader.readArray(reader1 -> CvssScore.fromJson(reader1));
                    continue;
                }
                if ("links".equals(fieldName)) {
                    List links;
                    deserializedCveResult.links = links = reader.readArray(reader1 -> CveLink.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCveResult.description = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCveResult.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCveResult;
        });
    }
}

