/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.CryptoKey;
import com.azure.resourcemanager.iotfirmwaredefense.models.CryptoKeyType;
import com.azure.resourcemanager.iotfirmwaredefense.models.PairedKey;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class CryptoKeyResourceInner
extends ProxyResource {
    private CryptoKey innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private CryptoKeyResourceInner() {
    }

    private CryptoKey innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String cryptoKeyId() {
        return this.innerProperties() == null ? null : this.innerProperties().cryptoKeyId();
    }

    public CryptoKeyType keyType() {
        return this.innerProperties() == null ? null : this.innerProperties().keyType();
    }

    public Long cryptoKeySize() {
        return this.innerProperties() == null ? null : this.innerProperties().cryptoKeySize();
    }

    public String keyAlgorithm() {
        return this.innerProperties() == null ? null : this.innerProperties().keyAlgorithm();
    }

    public List<String> usage() {
        return this.innerProperties() == null ? null : this.innerProperties().usage();
    }

    public List<String> filePaths() {
        return this.innerProperties() == null ? null : this.innerProperties().filePaths();
    }

    public PairedKey pairedKey() {
        return this.innerProperties() == null ? null : this.innerProperties().pairedKey();
    }

    public Boolean isShortKeySize() {
        return this.innerProperties() == null ? null : this.innerProperties().isShortKeySize();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CryptoKeyResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (CryptoKeyResourceInner)((Object)jsonReader.readObject(reader -> {
            CryptoKeyResourceInner deserializedCryptoKeyResourceInner = new CryptoKeyResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCryptoKeyResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCryptoKeyResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCryptoKeyResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCryptoKeyResourceInner.innerProperties = CryptoKey.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedCryptoKeyResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCryptoKeyResourceInner;
        }));
    }
}

