/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.models.CryptoKeyType;
import com.azure.resourcemanager.iotfirmwaredefense.models.PairedKey;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class CryptoKey
implements JsonSerializable<CryptoKey> {
    private String cryptoKeyId;
    private CryptoKeyType keyType;
    private Long cryptoKeySize;
    private String keyAlgorithm;
    private List<String> usage;
    private List<String> filePaths;
    private PairedKey pairedKey;
    private Boolean isShortKeySize;
    private ProvisioningState provisioningState;

    private CryptoKey() {
    }

    public String cryptoKeyId() {
        return this.cryptoKeyId;
    }

    public CryptoKeyType keyType() {
        return this.keyType;
    }

    public Long cryptoKeySize() {
        return this.cryptoKeySize;
    }

    public String keyAlgorithm() {
        return this.keyAlgorithm;
    }

    public List<String> usage() {
        return this.usage;
    }

    public List<String> filePaths() {
        return this.filePaths;
    }

    public PairedKey pairedKey() {
        return this.pairedKey;
    }

    public Boolean isShortKeySize() {
        return this.isShortKeySize;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.pairedKey() != null) {
            this.pairedKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("cryptoKeyId", this.cryptoKeyId);
        jsonWriter.writeStringField("keyType", this.keyType == null ? null : this.keyType.toString());
        jsonWriter.writeNumberField("cryptoKeySize", (Number)this.cryptoKeySize);
        jsonWriter.writeStringField("keyAlgorithm", this.keyAlgorithm);
        jsonWriter.writeArrayField("usage", this.usage, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("pairedKey", (JsonSerializable)this.pairedKey);
        jsonWriter.writeBooleanField("isShortKeySize", this.isShortKeySize);
        return jsonWriter.writeEndObject();
    }

    public static CryptoKey fromJson(JsonReader jsonReader) throws IOException {
        return (CryptoKey)jsonReader.readObject(reader -> {
            CryptoKey deserializedCryptoKey = new CryptoKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("cryptoKeyId".equals(fieldName)) {
                    deserializedCryptoKey.cryptoKeyId = reader.getString();
                    continue;
                }
                if ("keyType".equals(fieldName)) {
                    deserializedCryptoKey.keyType = CryptoKeyType.fromString(reader.getString());
                    continue;
                }
                if ("cryptoKeySize".equals(fieldName)) {
                    deserializedCryptoKey.cryptoKeySize = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("keyAlgorithm".equals(fieldName)) {
                    deserializedCryptoKey.keyAlgorithm = reader.getString();
                    continue;
                }
                if ("usage".equals(fieldName)) {
                    List usage;
                    deserializedCryptoKey.usage = usage = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("filePaths".equals(fieldName)) {
                    List filePaths;
                    deserializedCryptoKey.filePaths = filePaths = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("pairedKey".equals(fieldName)) {
                    deserializedCryptoKey.pairedKey = PairedKey.fromJson(reader);
                    continue;
                }
                if ("isShortKeySize".equals(fieldName)) {
                    deserializedCryptoKey.isShortKeySize = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCryptoKey.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCryptoKey;
        });
    }
}

