/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.CryptoCertificate;
import com.azure.resourcemanager.iotfirmwaredefense.models.CertificateUsage;
import com.azure.resourcemanager.iotfirmwaredefense.models.CryptoCertificateEntity;
import com.azure.resourcemanager.iotfirmwaredefense.models.PairedKey;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class CryptoCertificateResourceInner
extends ProxyResource {
    private CryptoCertificate innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private CryptoCertificateResourceInner() {
    }

    private CryptoCertificate innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String cryptoCertId() {
        return this.innerProperties() == null ? null : this.innerProperties().cryptoCertId();
    }

    public String certificateName() {
        return this.innerProperties() == null ? null : this.innerProperties().certificateName();
    }

    public CryptoCertificateEntity subject() {
        return this.innerProperties() == null ? null : this.innerProperties().subject();
    }

    public CryptoCertificateEntity issuer() {
        return this.innerProperties() == null ? null : this.innerProperties().issuer();
    }

    public OffsetDateTime issuedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().issuedDate();
    }

    public OffsetDateTime expirationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().expirationDate();
    }

    public String certificateRole() {
        return this.innerProperties() == null ? null : this.innerProperties().certificateRole();
    }

    public String signatureAlgorithm() {
        return this.innerProperties() == null ? null : this.innerProperties().signatureAlgorithm();
    }

    public Long certificateKeySize() {
        return this.innerProperties() == null ? null : this.innerProperties().certificateKeySize();
    }

    public String certificateKeyAlgorithm() {
        return this.innerProperties() == null ? null : this.innerProperties().certificateKeyAlgorithm();
    }

    public String encoding() {
        return this.innerProperties() == null ? null : this.innerProperties().encoding();
    }

    public String serialNumber() {
        return this.innerProperties() == null ? null : this.innerProperties().serialNumber();
    }

    public String fingerprint() {
        return this.innerProperties() == null ? null : this.innerProperties().fingerprint();
    }

    public List<CertificateUsage> certificateUsage() {
        return this.innerProperties() == null ? null : this.innerProperties().certificateUsage();
    }

    public List<String> filePaths() {
        return this.innerProperties() == null ? null : this.innerProperties().filePaths();
    }

    public PairedKey pairedKey() {
        return this.innerProperties() == null ? null : this.innerProperties().pairedKey();
    }

    public Boolean isExpired() {
        return this.innerProperties() == null ? null : this.innerProperties().isExpired();
    }

    public Boolean isSelfSigned() {
        return this.innerProperties() == null ? null : this.innerProperties().isSelfSigned();
    }

    public Boolean isWeakSignature() {
        return this.innerProperties() == null ? null : this.innerProperties().isWeakSignature();
    }

    public Boolean isShortKeySize() {
        return this.innerProperties() == null ? null : this.innerProperties().isShortKeySize();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CryptoCertificateResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (CryptoCertificateResourceInner)((Object)jsonReader.readObject(reader -> {
            CryptoCertificateResourceInner deserializedCryptoCertificateResourceInner = new CryptoCertificateResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCryptoCertificateResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCryptoCertificateResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCryptoCertificateResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCryptoCertificateResourceInner.innerProperties = CryptoCertificate.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedCryptoCertificateResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCryptoCertificateResourceInner;
        }));
    }
}

