/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.models.CertificateUsage;
import com.azure.resourcemanager.iotfirmwaredefense.models.CryptoCertificateEntity;
import com.azure.resourcemanager.iotfirmwaredefense.models.PairedKey;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class CryptoCertificate
implements JsonSerializable<CryptoCertificate> {
    private String cryptoCertId;
    private String certificateName;
    private CryptoCertificateEntity subject;
    private CryptoCertificateEntity issuer;
    private OffsetDateTime issuedDate;
    private OffsetDateTime expirationDate;
    private String certificateRole;
    private String signatureAlgorithm;
    private Long certificateKeySize;
    private String certificateKeyAlgorithm;
    private String encoding;
    private String serialNumber;
    private String fingerprint;
    private List<CertificateUsage> certificateUsage;
    private List<String> filePaths;
    private PairedKey pairedKey;
    private Boolean isExpired;
    private Boolean isSelfSigned;
    private Boolean isWeakSignature;
    private Boolean isShortKeySize;
    private ProvisioningState provisioningState;

    private CryptoCertificate() {
    }

    public String cryptoCertId() {
        return this.cryptoCertId;
    }

    public String certificateName() {
        return this.certificateName;
    }

    public CryptoCertificateEntity subject() {
        return this.subject;
    }

    public CryptoCertificateEntity issuer() {
        return this.issuer;
    }

    public OffsetDateTime issuedDate() {
        return this.issuedDate;
    }

    public OffsetDateTime expirationDate() {
        return this.expirationDate;
    }

    public String certificateRole() {
        return this.certificateRole;
    }

    public String signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public Long certificateKeySize() {
        return this.certificateKeySize;
    }

    public String certificateKeyAlgorithm() {
        return this.certificateKeyAlgorithm;
    }

    public String encoding() {
        return this.encoding;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public String fingerprint() {
        return this.fingerprint;
    }

    public List<CertificateUsage> certificateUsage() {
        return this.certificateUsage;
    }

    public List<String> filePaths() {
        return this.filePaths;
    }

    public PairedKey pairedKey() {
        return this.pairedKey;
    }

    public Boolean isExpired() {
        return this.isExpired;
    }

    public Boolean isSelfSigned() {
        return this.isSelfSigned;
    }

    public Boolean isWeakSignature() {
        return this.isWeakSignature;
    }

    public Boolean isShortKeySize() {
        return this.isShortKeySize;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.subject() != null) {
            this.subject().validate();
        }
        if (this.issuer() != null) {
            this.issuer().validate();
        }
        if (this.pairedKey() != null) {
            this.pairedKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("cryptoCertId", this.cryptoCertId);
        jsonWriter.writeStringField("certificateName", this.certificateName);
        jsonWriter.writeJsonField("subject", (JsonSerializable)this.subject);
        jsonWriter.writeJsonField("issuer", (JsonSerializable)this.issuer);
        jsonWriter.writeStringField("issuedDate", this.issuedDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.issuedDate));
        jsonWriter.writeStringField("expirationDate", this.expirationDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDate));
        jsonWriter.writeStringField("certificateRole", this.certificateRole);
        jsonWriter.writeStringField("signatureAlgorithm", this.signatureAlgorithm);
        jsonWriter.writeNumberField("certificateKeySize", (Number)this.certificateKeySize);
        jsonWriter.writeStringField("certificateKeyAlgorithm", this.certificateKeyAlgorithm);
        jsonWriter.writeStringField("encoding", this.encoding);
        jsonWriter.writeStringField("serialNumber", this.serialNumber);
        jsonWriter.writeStringField("fingerprint", this.fingerprint);
        jsonWriter.writeArrayField("certificateUsage", this.certificateUsage, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("pairedKey", (JsonSerializable)this.pairedKey);
        jsonWriter.writeBooleanField("isExpired", this.isExpired);
        jsonWriter.writeBooleanField("isSelfSigned", this.isSelfSigned);
        jsonWriter.writeBooleanField("isWeakSignature", this.isWeakSignature);
        jsonWriter.writeBooleanField("isShortKeySize", this.isShortKeySize);
        return jsonWriter.writeEndObject();
    }

    public static CryptoCertificate fromJson(JsonReader jsonReader) throws IOException {
        return (CryptoCertificate)jsonReader.readObject(reader -> {
            CryptoCertificate deserializedCryptoCertificate = new CryptoCertificate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("cryptoCertId".equals(fieldName)) {
                    deserializedCryptoCertificate.cryptoCertId = reader.getString();
                    continue;
                }
                if ("certificateName".equals(fieldName)) {
                    deserializedCryptoCertificate.certificateName = reader.getString();
                    continue;
                }
                if ("subject".equals(fieldName)) {
                    deserializedCryptoCertificate.subject = CryptoCertificateEntity.fromJson(reader);
                    continue;
                }
                if ("issuer".equals(fieldName)) {
                    deserializedCryptoCertificate.issuer = CryptoCertificateEntity.fromJson(reader);
                    continue;
                }
                if ("issuedDate".equals(fieldName)) {
                    deserializedCryptoCertificate.issuedDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expirationDate".equals(fieldName)) {
                    deserializedCryptoCertificate.expirationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("certificateRole".equals(fieldName)) {
                    deserializedCryptoCertificate.certificateRole = reader.getString();
                    continue;
                }
                if ("signatureAlgorithm".equals(fieldName)) {
                    deserializedCryptoCertificate.signatureAlgorithm = reader.getString();
                    continue;
                }
                if ("certificateKeySize".equals(fieldName)) {
                    deserializedCryptoCertificate.certificateKeySize = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("certificateKeyAlgorithm".equals(fieldName)) {
                    deserializedCryptoCertificate.certificateKeyAlgorithm = reader.getString();
                    continue;
                }
                if ("encoding".equals(fieldName)) {
                    deserializedCryptoCertificate.encoding = reader.getString();
                    continue;
                }
                if ("serialNumber".equals(fieldName)) {
                    deserializedCryptoCertificate.serialNumber = reader.getString();
                    continue;
                }
                if ("fingerprint".equals(fieldName)) {
                    deserializedCryptoCertificate.fingerprint = reader.getString();
                    continue;
                }
                if ("certificateUsage".equals(fieldName)) {
                    List certificateUsage;
                    deserializedCryptoCertificate.certificateUsage = certificateUsage = reader.readArray(reader1 -> CertificateUsage.fromString(reader1.getString()));
                    continue;
                }
                if ("filePaths".equals(fieldName)) {
                    List filePaths;
                    deserializedCryptoCertificate.filePaths = filePaths = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("pairedKey".equals(fieldName)) {
                    deserializedCryptoCertificate.pairedKey = PairedKey.fromJson(reader);
                    continue;
                }
                if ("isExpired".equals(fieldName)) {
                    deserializedCryptoCertificate.isExpired = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isSelfSigned".equals(fieldName)) {
                    deserializedCryptoCertificate.isSelfSigned = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isWeakSignature".equals(fieldName)) {
                    deserializedCryptoCertificate.isWeakSignature = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isShortKeySize".equals(fieldName)) {
                    deserializedCryptoCertificate.isShortKeySize = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCryptoCertificate.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCryptoCertificate;
        });
    }
}

