/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.models.BinaryHardeningFeatures;
import com.azure.resourcemanager.iotfirmwaredefense.models.ExecutableClass;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import java.io.IOException;

public final class BinaryHardeningResult
implements JsonSerializable<BinaryHardeningResult> {
    private String binaryHardeningId;
    private BinaryHardeningFeatures securityHardeningFeatures;
    private String executableArchitecture;
    private String filePath;
    private ExecutableClass executableClass;
    private String runpath;
    private String rpath;
    private ProvisioningState provisioningState;

    private BinaryHardeningResult() {
    }

    public String binaryHardeningId() {
        return this.binaryHardeningId;
    }

    public BinaryHardeningFeatures securityHardeningFeatures() {
        return this.securityHardeningFeatures;
    }

    public String executableArchitecture() {
        return this.executableArchitecture;
    }

    public String filePath() {
        return this.filePath;
    }

    public ExecutableClass executableClass() {
        return this.executableClass;
    }

    public String runpath() {
        return this.runpath;
    }

    public String rpath() {
        return this.rpath;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.securityHardeningFeatures() != null) {
            this.securityHardeningFeatures().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("binaryHardeningId", this.binaryHardeningId);
        jsonWriter.writeJsonField("securityHardeningFeatures", (JsonSerializable)this.securityHardeningFeatures);
        jsonWriter.writeStringField("executableArchitecture", this.executableArchitecture);
        jsonWriter.writeStringField("filePath", this.filePath);
        jsonWriter.writeStringField("executableClass", this.executableClass == null ? null : this.executableClass.toString());
        jsonWriter.writeStringField("runpath", this.runpath);
        jsonWriter.writeStringField("rpath", this.rpath);
        return jsonWriter.writeEndObject();
    }

    public static BinaryHardeningResult fromJson(JsonReader jsonReader) throws IOException {
        return (BinaryHardeningResult)jsonReader.readObject(reader -> {
            BinaryHardeningResult deserializedBinaryHardeningResult = new BinaryHardeningResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("binaryHardeningId".equals(fieldName)) {
                    deserializedBinaryHardeningResult.binaryHardeningId = reader.getString();
                    continue;
                }
                if ("securityHardeningFeatures".equals(fieldName)) {
                    deserializedBinaryHardeningResult.securityHardeningFeatures = BinaryHardeningFeatures.fromJson(reader);
                    continue;
                }
                if ("executableArchitecture".equals(fieldName)) {
                    deserializedBinaryHardeningResult.executableArchitecture = reader.getString();
                    continue;
                }
                if ("filePath".equals(fieldName)) {
                    deserializedBinaryHardeningResult.filePath = reader.getString();
                    continue;
                }
                if ("executableClass".equals(fieldName)) {
                    deserializedBinaryHardeningResult.executableClass = ExecutableClass.fromString(reader.getString());
                    continue;
                }
                if ("runpath".equals(fieldName)) {
                    deserializedBinaryHardeningResult.runpath = reader.getString();
                    continue;
                }
                if ("rpath".equals(fieldName)) {
                    deserializedBinaryHardeningResult.rpath = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBinaryHardeningResult.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBinaryHardeningResult;
        });
    }
}

