/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.hardwaresecuritymodules.models.BackupRestoreRequestBaseProperties;
import java.io.IOException;

public final class RestoreRequestProperties
extends BackupRestoreRequestBaseProperties {
    private String backupId;
    private static final ClientLogger LOGGER = new ClientLogger(RestoreRequestProperties.class);

    public String backupId() {
        return this.backupId;
    }

    public RestoreRequestProperties withBackupId(String backupId) {
        this.backupId = backupId;
        return this;
    }

    @Override
    public RestoreRequestProperties withAzureStorageBlobContainerUri(String azureStorageBlobContainerUri) {
        super.withAzureStorageBlobContainerUri(azureStorageBlobContainerUri);
        return this;
    }

    @Override
    public RestoreRequestProperties withToken(String token) {
        super.withToken(token);
        return this;
    }

    @Override
    public void validate() {
        if (this.backupId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property backupId in model RestoreRequestProperties"));
        }
        if (this.azureStorageBlobContainerUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property azureStorageBlobContainerUri in model RestoreRequestProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("azureStorageBlobContainerUri", this.azureStorageBlobContainerUri());
        jsonWriter.writeStringField("token", this.token());
        jsonWriter.writeStringField("backupId", this.backupId);
        return jsonWriter.writeEndObject();
    }

    public static RestoreRequestProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RestoreRequestProperties)jsonReader.readObject(reader -> {
            RestoreRequestProperties deserializedRestoreRequestProperties = new RestoreRequestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("azureStorageBlobContainerUri".equals(fieldName)) {
                    deserializedRestoreRequestProperties.withAzureStorageBlobContainerUri(reader.getString());
                    continue;
                }
                if ("token".equals(fieldName)) {
                    deserializedRestoreRequestProperties.withToken(reader.getString());
                    continue;
                }
                if ("backupId".equals(fieldName)) {
                    deserializedRestoreRequestProperties.backupId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestoreRequestProperties;
        });
    }
}

