/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.hardwaresecuritymodules.models.ApiEntityReference;
import com.azure.resourcemanager.hardwaresecuritymodules.models.NetworkInterface;
import java.io.IOException;
import java.util.List;

public final class NetworkProfile
implements JsonSerializable<NetworkProfile> {
    private ApiEntityReference subnet;
    private List<NetworkInterface> networkInterfaces;

    public ApiEntityReference subnet() {
        return this.subnet;
    }

    public NetworkProfile withSubnet(ApiEntityReference subnet) {
        this.subnet = subnet;
        return this;
    }

    public List<NetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public NetworkProfile withNetworkInterfaces(List<NetworkInterface> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
        return this;
    }

    public void validate() {
        if (this.subnet() != null) {
            this.subnet().validate();
        }
        if (this.networkInterfaces() != null) {
            this.networkInterfaces().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("subnet", (JsonSerializable)this.subnet);
        jsonWriter.writeArrayField("networkInterfaces", this.networkInterfaces, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkProfile fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkProfile)jsonReader.readObject(reader -> {
            NetworkProfile deserializedNetworkProfile = new NetworkProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnet".equals(fieldName)) {
                    deserializedNetworkProfile.subnet = ApiEntityReference.fromJson(reader);
                    continue;
                }
                if ("networkInterfaces".equals(fieldName)) {
                    List networkInterfaces;
                    deserializedNetworkProfile.networkInterfaces = networkInterfaces = reader.readArray(reader1 -> NetworkInterface.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkProfile;
        });
    }
}

