/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.hardwaresecuritymodules.HardwareSecurityModulesManager;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.hardwaresecuritymodules.models.PrivateEndpointConnection;
import com.azure.resourcemanager.hardwaresecuritymodules.models.PrivateEndpointConnectionProperties;

public final class PrivateEndpointConnectionImpl
implements PrivateEndpointConnection,
PrivateEndpointConnection.Definition {
    private PrivateEndpointConnectionInner innerObject;
    private final HardwareSecurityModulesManager serviceManager;
    private String resourceGroupName;
    private String cloudHsmClusterName;
    private String peConnectionName;

    PrivateEndpointConnectionImpl(PrivateEndpointConnectionInner innerObject, HardwareSecurityModulesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public PrivateEndpointConnectionProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public PrivateEndpointConnectionInner innerModel() {
        return this.innerObject;
    }

    private HardwareSecurityModulesManager manager() {
        return this.serviceManager;
    }

    @Override
    public PrivateEndpointConnectionImpl withExistingCloudHsmCluster(String resourceGroupName, String cloudHsmClusterName) {
        this.resourceGroupName = resourceGroupName;
        this.cloudHsmClusterName = cloudHsmClusterName;
        return this;
    }

    @Override
    public PrivateEndpointConnection create() {
        this.innerObject = (PrivateEndpointConnectionInner)((Object)this.serviceManager.serviceClient().getCloudHsmClusterPrivateEndpointConnections().createWithResponse(this.resourceGroupName, this.cloudHsmClusterName, this.peConnectionName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnection create(Context context) {
        this.innerObject = (PrivateEndpointConnectionInner)((Object)this.serviceManager.serviceClient().getCloudHsmClusterPrivateEndpointConnections().createWithResponse(this.resourceGroupName, this.cloudHsmClusterName, this.peConnectionName, this.innerModel(), context).getValue());
        return this;
    }

    PrivateEndpointConnectionImpl(String name, HardwareSecurityModulesManager serviceManager) {
        this.innerObject = new PrivateEndpointConnectionInner();
        this.serviceManager = serviceManager;
        this.peConnectionName = name;
    }

    @Override
    public PrivateEndpointConnection refresh() {
        this.innerObject = (PrivateEndpointConnectionInner)((Object)this.serviceManager.serviceClient().getCloudHsmClusterPrivateEndpointConnections().getWithResponse(this.resourceGroupName, this.cloudHsmClusterName, this.peConnectionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnection refresh(Context context) {
        this.innerObject = (PrivateEndpointConnectionInner)((Object)this.serviceManager.serviceClient().getCloudHsmClusterPrivateEndpointConnections().getWithResponse(this.resourceGroupName, this.cloudHsmClusterName, this.peConnectionName, context).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnectionImpl withProperties(PrivateEndpointConnectionProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public PrivateEndpointConnectionImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }
}

