/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.hardwaresecuritymodules.HardwareSecurityModulesManager;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.CloudHsmClusterBackupStatusClient;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.BackupResultInner;
import com.azure.resourcemanager.hardwaresecuritymodules.implementation.BackupResultImpl;
import com.azure.resourcemanager.hardwaresecuritymodules.models.BackupResult;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusterBackupStatus;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusterBackupStatusGetResponse;

public final class CloudHsmClusterBackupStatusImpl
implements CloudHsmClusterBackupStatus {
    private static final ClientLogger LOGGER = new ClientLogger(CloudHsmClusterBackupStatusImpl.class);
    private final CloudHsmClusterBackupStatusClient innerClient;
    private final HardwareSecurityModulesManager serviceManager;

    public CloudHsmClusterBackupStatusImpl(CloudHsmClusterBackupStatusClient innerClient, HardwareSecurityModulesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<BackupResult> getWithResponse(String resourceGroupName, String cloudHsmClusterName, String jobId, Context context) {
        CloudHsmClusterBackupStatusGetResponse inner = this.serviceClient().getWithResponse(resourceGroupName, cloudHsmClusterName, jobId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BackupResultImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public BackupResult get(String resourceGroupName, String cloudHsmClusterName, String jobId) {
        BackupResultInner inner = this.serviceClient().get(resourceGroupName, cloudHsmClusterName, jobId);
        if (inner != null) {
            return new BackupResultImpl(inner, this.manager());
        }
        return null;
    }

    private CloudHsmClusterBackupStatusClient serviceClient() {
        return this.innerClient;
    }

    private HardwareSecurityModulesManager manager() {
        return this.serviceManager;
    }
}

