/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.SubscriptionInner;
import java.io.IOException;
import java.util.List;

public final class SubscriptionsListResult
implements JsonSerializable<SubscriptionsListResult> {
    private List<SubscriptionInner> value;
    private String nextLink;

    public List<SubscriptionInner> value() {
        return this.value;
    }

    public SubscriptionsListResult withValue(List<SubscriptionInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public SubscriptionsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionsListResult fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionsListResult)jsonReader.readObject(reader -> {
            SubscriptionsListResult deserializedSubscriptionsListResult = new SubscriptionsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSubscriptionsListResult.value = value = reader.readArray(reader1 -> SubscriptionInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSubscriptionsListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionsListResult;
        });
    }
}

