/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.StorageBlobDeadLetterDestinationProperties;
import com.azure.resourcemanager.eventgrid.models.DeadLetterDestination;
import com.azure.resourcemanager.eventgrid.models.DeadLetterEndPointType;
import java.io.IOException;

public final class StorageBlobDeadLetterDestination
extends DeadLetterDestination {
    private DeadLetterEndPointType endpointType = DeadLetterEndPointType.STORAGE_BLOB;
    private StorageBlobDeadLetterDestinationProperties innerProperties;

    @Override
    public DeadLetterEndPointType endpointType() {
        return this.endpointType;
    }

    StorageBlobDeadLetterDestinationProperties innerProperties() {
        return this.innerProperties;
    }

    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    public StorageBlobDeadLetterDestination withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageBlobDeadLetterDestinationProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    public String blobContainerName() {
        return this.innerProperties() == null ? null : this.innerProperties().blobContainerName();
    }

    public StorageBlobDeadLetterDestination withBlobContainerName(String blobContainerName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageBlobDeadLetterDestinationProperties();
        }
        this.innerProperties().withBlobContainerName(blobContainerName);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static StorageBlobDeadLetterDestination fromJson(JsonReader jsonReader) throws IOException {
        return (StorageBlobDeadLetterDestination)jsonReader.readObject(reader -> {
            StorageBlobDeadLetterDestination deserializedStorageBlobDeadLetterDestination = new StorageBlobDeadLetterDestination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpointType".equals(fieldName)) {
                    deserializedStorageBlobDeadLetterDestination.endpointType = DeadLetterEndPointType.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedStorageBlobDeadLetterDestination.innerProperties = StorageBlobDeadLetterDestinationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageBlobDeadLetterDestination;
        });
    }
}

