/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ResourceMoveChangeHistory
implements JsonSerializable<ResourceMoveChangeHistory> {
    private String azureSubscriptionId;
    private String resourceGroupName;
    private OffsetDateTime changedTimeUtc;

    public String azureSubscriptionId() {
        return this.azureSubscriptionId;
    }

    public ResourceMoveChangeHistory withAzureSubscriptionId(String azureSubscriptionId) {
        this.azureSubscriptionId = azureSubscriptionId;
        return this;
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public ResourceMoveChangeHistory withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public OffsetDateTime changedTimeUtc() {
        return this.changedTimeUtc;
    }

    public ResourceMoveChangeHistory withChangedTimeUtc(OffsetDateTime changedTimeUtc) {
        this.changedTimeUtc = changedTimeUtc;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("azureSubscriptionId", this.azureSubscriptionId);
        jsonWriter.writeStringField("resourceGroupName", this.resourceGroupName);
        jsonWriter.writeStringField("changedTimeUtc", this.changedTimeUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.changedTimeUtc));
        return jsonWriter.writeEndObject();
    }

    public static ResourceMoveChangeHistory fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceMoveChangeHistory)jsonReader.readObject(reader -> {
            ResourceMoveChangeHistory deserializedResourceMoveChangeHistory = new ResourceMoveChangeHistory();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("azureSubscriptionId".equals(fieldName)) {
                    deserializedResourceMoveChangeHistory.azureSubscriptionId = reader.getString();
                    continue;
                }
                if ("resourceGroupName".equals(fieldName)) {
                    deserializedResourceMoveChangeHistory.resourceGroupName = reader.getString();
                    continue;
                }
                if ("changedTimeUtc".equals(fieldName)) {
                    deserializedResourceMoveChangeHistory.changedTimeUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceMoveChangeHistory;
        });
    }
}

