/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DeadLetterWithResourceIdentity;
import java.io.IOException;
import java.time.Duration;

public final class QueueInfo
implements JsonSerializable<QueueInfo> {
    private Integer receiveLockDurationInSeconds;
    private Integer maxDeliveryCount;
    private DeadLetterWithResourceIdentity deadLetterDestinationWithResourceIdentity;
    private Duration eventTimeToLive;

    public Integer receiveLockDurationInSeconds() {
        return this.receiveLockDurationInSeconds;
    }

    public QueueInfo withReceiveLockDurationInSeconds(Integer receiveLockDurationInSeconds) {
        this.receiveLockDurationInSeconds = receiveLockDurationInSeconds;
        return this;
    }

    public Integer maxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public QueueInfo withMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public DeadLetterWithResourceIdentity deadLetterDestinationWithResourceIdentity() {
        return this.deadLetterDestinationWithResourceIdentity;
    }

    public QueueInfo withDeadLetterDestinationWithResourceIdentity(DeadLetterWithResourceIdentity deadLetterDestinationWithResourceIdentity) {
        this.deadLetterDestinationWithResourceIdentity = deadLetterDestinationWithResourceIdentity;
        return this;
    }

    public Duration eventTimeToLive() {
        return this.eventTimeToLive;
    }

    public QueueInfo withEventTimeToLive(Duration eventTimeToLive) {
        this.eventTimeToLive = eventTimeToLive;
        return this;
    }

    public void validate() {
        if (this.deadLetterDestinationWithResourceIdentity() != null) {
            this.deadLetterDestinationWithResourceIdentity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("receiveLockDurationInSeconds", (Number)this.receiveLockDurationInSeconds);
        jsonWriter.writeNumberField("maxDeliveryCount", (Number)this.maxDeliveryCount);
        jsonWriter.writeJsonField("deadLetterDestinationWithResourceIdentity", (JsonSerializable)this.deadLetterDestinationWithResourceIdentity);
        jsonWriter.writeStringField("eventTimeToLive", CoreUtils.durationToStringWithDays((Duration)this.eventTimeToLive));
        return jsonWriter.writeEndObject();
    }

    public static QueueInfo fromJson(JsonReader jsonReader) throws IOException {
        return (QueueInfo)jsonReader.readObject(reader -> {
            QueueInfo deserializedQueueInfo = new QueueInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("receiveLockDurationInSeconds".equals(fieldName)) {
                    deserializedQueueInfo.receiveLockDurationInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxDeliveryCount".equals(fieldName)) {
                    deserializedQueueInfo.maxDeliveryCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("deadLetterDestinationWithResourceIdentity".equals(fieldName)) {
                    deserializedQueueInfo.deadLetterDestinationWithResourceIdentity = DeadLetterWithResourceIdentity.fromJson(reader);
                    continue;
                }
                if ("eventTimeToLive".equals(fieldName)) {
                    deserializedQueueInfo.eventTimeToLive = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueueInfo;
        });
    }
}

