/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerEventSubscriptionDestinationProperties;
import com.azure.resourcemanager.eventgrid.models.EndpointType;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionDestination;
import java.io.IOException;

public final class PartnerEventSubscriptionDestination
extends EventSubscriptionDestination {
    private EndpointType endpointType = EndpointType.PARTNER_DESTINATION;
    private PartnerEventSubscriptionDestinationProperties innerProperties;

    @Override
    public EndpointType endpointType() {
        return this.endpointType;
    }

    PartnerEventSubscriptionDestinationProperties innerProperties() {
        return this.innerProperties;
    }

    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    public PartnerEventSubscriptionDestination withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PartnerEventSubscriptionDestination fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerEventSubscriptionDestination)jsonReader.readObject(reader -> {
            PartnerEventSubscriptionDestination deserializedPartnerEventSubscriptionDestination = new PartnerEventSubscriptionDestination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpointType".equals(fieldName)) {
                    deserializedPartnerEventSubscriptionDestination.endpointType = EndpointType.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPartnerEventSubscriptionDestination.innerProperties = PartnerEventSubscriptionDestinationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerEventSubscriptionDestination;
        });
    }
}

