/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.PartnerEndpointType;
import com.azure.resourcemanager.eventgrid.models.ResourceMoveChangeHistory;
import com.azure.resourcemanager.eventgrid.models.WebhookPartnerDestinationInfo;
import java.io.IOException;
import java.util.List;

public class PartnerDestinationInfo
implements JsonSerializable<PartnerDestinationInfo> {
    private PartnerEndpointType endpointType = PartnerEndpointType.fromString("PartnerDestinationInfo");
    private String azureSubscriptionId;
    private String resourceGroupName;
    private String name;
    private String endpointServiceContext;
    private List<ResourceMoveChangeHistory> resourceMoveChangeHistory;

    public PartnerEndpointType endpointType() {
        return this.endpointType;
    }

    public String azureSubscriptionId() {
        return this.azureSubscriptionId;
    }

    public PartnerDestinationInfo withAzureSubscriptionId(String azureSubscriptionId) {
        this.azureSubscriptionId = azureSubscriptionId;
        return this;
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public PartnerDestinationInfo withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PartnerDestinationInfo withName(String name) {
        this.name = name;
        return this;
    }

    public String endpointServiceContext() {
        return this.endpointServiceContext;
    }

    public PartnerDestinationInfo withEndpointServiceContext(String endpointServiceContext) {
        this.endpointServiceContext = endpointServiceContext;
        return this;
    }

    public List<ResourceMoveChangeHistory> resourceMoveChangeHistory() {
        return this.resourceMoveChangeHistory;
    }

    public PartnerDestinationInfo withResourceMoveChangeHistory(List<ResourceMoveChangeHistory> resourceMoveChangeHistory) {
        this.resourceMoveChangeHistory = resourceMoveChangeHistory;
        return this;
    }

    public void validate() {
        if (this.resourceMoveChangeHistory() != null) {
            this.resourceMoveChangeHistory().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        jsonWriter.writeStringField("azureSubscriptionId", this.azureSubscriptionId);
        jsonWriter.writeStringField("resourceGroupName", this.resourceGroupName);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("endpointServiceContext", this.endpointServiceContext);
        jsonWriter.writeArrayField("resourceMoveChangeHistory", this.resourceMoveChangeHistory, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PartnerDestinationInfo fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerDestinationInfo)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                PartnerDestinationInfo partnerDestinationInfo;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("endpointType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("WebHook".equals(discriminatorValue)) {
                    partnerDestinationInfo = WebhookPartnerDestinationInfo.fromJson(readerToUse.reset());
                    return partnerDestinationInfo;
                }
                partnerDestinationInfo = PartnerDestinationInfo.fromJsonKnownDiscriminator(readerToUse.reset());
                return partnerDestinationInfo;
            }
        });
    }

    static PartnerDestinationInfo fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (PartnerDestinationInfo)jsonReader.readObject(reader -> {
            PartnerDestinationInfo deserializedPartnerDestinationInfo = new PartnerDestinationInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpointType".equals(fieldName)) {
                    deserializedPartnerDestinationInfo.endpointType = PartnerEndpointType.fromString(reader.getString());
                    continue;
                }
                if ("azureSubscriptionId".equals(fieldName)) {
                    deserializedPartnerDestinationInfo.azureSubscriptionId = reader.getString();
                    continue;
                }
                if ("resourceGroupName".equals(fieldName)) {
                    deserializedPartnerDestinationInfo.resourceGroupName = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPartnerDestinationInfo.name = reader.getString();
                    continue;
                }
                if ("endpointServiceContext".equals(fieldName)) {
                    deserializedPartnerDestinationInfo.endpointServiceContext = reader.getString();
                    continue;
                }
                if ("resourceMoveChangeHistory".equals(fieldName)) {
                    List resourceMoveChangeHistory;
                    deserializedPartnerDestinationInfo.resourceMoveChangeHistory = resourceMoveChangeHistory = reader.readArray(reader1 -> ResourceMoveChangeHistory.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerDestinationInfo;
        });
    }
}

