/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerDestinationInner;
import com.azure.resourcemanager.eventgrid.models.PartnerDestinationActivationState;
import com.azure.resourcemanager.eventgrid.models.PartnerDestinationProvisioningState;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

public interface PartnerDestination {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public SystemData systemData();

    public UUID partnerRegistrationImmutableId();

    public String endpointServiceContext();

    public OffsetDateTime expirationTimeIfNotActivatedUtc();

    public PartnerDestinationProvisioningState provisioningState();

    public PartnerDestinationActivationState activationState();

    public String endpointBaseUrl();

    public String messageForActivation();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public PartnerDestinationInner innerModel();

    public Update update();

    public PartnerDestination refresh();

    public PartnerDestination refresh(Context var1);

    public Response<PartnerDestination> activateWithResponse(Context var1);

    public PartnerDestination activate();

    public static interface UpdateStages {

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags {
        public PartnerDestination apply();

        public PartnerDestination apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithMessageForActivation {
            public WithCreate withMessageForActivation(String var1);
        }

        public static interface WithEndpointBaseUrl {
            public WithCreate withEndpointBaseUrl(String var1);
        }

        public static interface WithActivationState {
            public WithCreate withActivationState(PartnerDestinationActivationState var1);
        }

        public static interface WithExpirationTimeIfNotActivatedUtc {
            public WithCreate withExpirationTimeIfNotActivatedUtc(OffsetDateTime var1);
        }

        public static interface WithEndpointServiceContext {
            public WithCreate withEndpointServiceContext(String var1);
        }

        public static interface WithPartnerRegistrationImmutableId {
            public WithCreate withPartnerRegistrationImmutableId(UUID var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithPartnerRegistrationImmutableId,
        WithEndpointServiceContext,
        WithExpirationTimeIfNotActivatedUtc,
        WithActivationState,
        WithEndpointBaseUrl,
        WithMessageForActivation {
            public PartnerDestination create();

            public PartnerDestination create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

