/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.Partner;
import java.io.IOException;
import java.util.List;

public final class PartnerAuthorization
implements JsonSerializable<PartnerAuthorization> {
    private Integer defaultMaximumExpirationTimeInDays;
    private List<Partner> authorizedPartnersList;

    public Integer defaultMaximumExpirationTimeInDays() {
        return this.defaultMaximumExpirationTimeInDays;
    }

    public PartnerAuthorization withDefaultMaximumExpirationTimeInDays(Integer defaultMaximumExpirationTimeInDays) {
        this.defaultMaximumExpirationTimeInDays = defaultMaximumExpirationTimeInDays;
        return this;
    }

    public List<Partner> authorizedPartnersList() {
        return this.authorizedPartnersList;
    }

    public PartnerAuthorization withAuthorizedPartnersList(List<Partner> authorizedPartnersList) {
        this.authorizedPartnersList = authorizedPartnersList;
        return this;
    }

    public void validate() {
        if (this.authorizedPartnersList() != null) {
            this.authorizedPartnersList().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("defaultMaximumExpirationTimeInDays", (Number)this.defaultMaximumExpirationTimeInDays);
        jsonWriter.writeArrayField("authorizedPartnersList", this.authorizedPartnersList, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PartnerAuthorization fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerAuthorization)jsonReader.readObject(reader -> {
            PartnerAuthorization deserializedPartnerAuthorization = new PartnerAuthorization();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("defaultMaximumExpirationTimeInDays".equals(fieldName)) {
                    deserializedPartnerAuthorization.defaultMaximumExpirationTimeInDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("authorizedPartnersList".equals(fieldName)) {
                    List authorizedPartnersList;
                    deserializedPartnerAuthorization.authorizedPartnersList = authorizedPartnersList = reader.readArray(reader1 -> Partner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerAuthorization;
        });
    }
}

