/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.UUID;

public final class Partner
implements JsonSerializable<Partner> {
    private UUID partnerRegistrationImmutableId;
    private String partnerName;
    private OffsetDateTime authorizationExpirationTimeInUtc;

    public UUID partnerRegistrationImmutableId() {
        return this.partnerRegistrationImmutableId;
    }

    public Partner withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        this.partnerRegistrationImmutableId = partnerRegistrationImmutableId;
        return this;
    }

    public String partnerName() {
        return this.partnerName;
    }

    public Partner withPartnerName(String partnerName) {
        this.partnerName = partnerName;
        return this;
    }

    public OffsetDateTime authorizationExpirationTimeInUtc() {
        return this.authorizationExpirationTimeInUtc;
    }

    public Partner withAuthorizationExpirationTimeInUtc(OffsetDateTime authorizationExpirationTimeInUtc) {
        this.authorizationExpirationTimeInUtc = authorizationExpirationTimeInUtc;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("partnerRegistrationImmutableId", Objects.toString(this.partnerRegistrationImmutableId, null));
        jsonWriter.writeStringField("partnerName", this.partnerName);
        jsonWriter.writeStringField("authorizationExpirationTimeInUtc", this.authorizationExpirationTimeInUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.authorizationExpirationTimeInUtc));
        return jsonWriter.writeEndObject();
    }

    public static Partner fromJson(JsonReader jsonReader) throws IOException {
        return (Partner)jsonReader.readObject(reader -> {
            Partner deserializedPartner = new Partner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("partnerRegistrationImmutableId".equals(fieldName)) {
                    deserializedPartner.partnerRegistrationImmutableId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("partnerName".equals(fieldName)) {
                    deserializedPartner.partnerName = reader.getString();
                    continue;
                }
                if ("authorizationExpirationTimeInUtc".equals(fieldName)) {
                    deserializedPartner.authorizationExpirationTimeInUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartner;
        });
    }
}

