/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.Filter;
import com.azure.resourcemanager.eventgrid.models.FilterOperatorType;
import java.io.IOException;

public final class NumberGreaterThanOrEqualsFilter
extends Filter {
    private FilterOperatorType operatorType = FilterOperatorType.NUMBER_GREATER_THAN_OR_EQUALS;
    private Double value;

    @Override
    public FilterOperatorType operatorType() {
        return this.operatorType;
    }

    public Double value() {
        return this.value;
    }

    public NumberGreaterThanOrEqualsFilter withValue(Double value) {
        this.value = value;
        return this;
    }

    @Override
    public NumberGreaterThanOrEqualsFilter withKey(String key) {
        super.withKey(key);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key());
        jsonWriter.writeStringField("operatorType", this.operatorType == null ? null : this.operatorType.toString());
        jsonWriter.writeNumberField("value", (Number)this.value);
        return jsonWriter.writeEndObject();
    }

    public static NumberGreaterThanOrEqualsFilter fromJson(JsonReader jsonReader) throws IOException {
        return (NumberGreaterThanOrEqualsFilter)jsonReader.readObject(reader -> {
            NumberGreaterThanOrEqualsFilter deserializedNumberGreaterThanOrEqualsFilter = new NumberGreaterThanOrEqualsFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedNumberGreaterThanOrEqualsFilter.withKey(reader.getString());
                    continue;
                }
                if ("operatorType".equals(fieldName)) {
                    deserializedNumberGreaterThanOrEqualsFilter.operatorType = FilterOperatorType.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedNumberGreaterThanOrEqualsFilter.value = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNumberGreaterThanOrEqualsFilter;
        });
    }
}

