/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.NetworkSecurityPerimeterProfileAccessRuleProperties;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterInfo;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterProfileAccessRuleDirection;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterSubscription;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityPerimeterProfileAccessRule
implements JsonSerializable<NetworkSecurityPerimeterProfileAccessRule> {
    private String fullyQualifiedArmId;
    private String name;
    private String type;
    private NetworkSecurityPerimeterProfileAccessRuleProperties innerProperties;

    public String fullyQualifiedArmId() {
        return this.fullyQualifiedArmId;
    }

    public NetworkSecurityPerimeterProfileAccessRule withFullyQualifiedArmId(String fullyQualifiedArmId) {
        this.fullyQualifiedArmId = fullyQualifiedArmId;
        return this;
    }

    public String name() {
        return this.name;
    }

    public NetworkSecurityPerimeterProfileAccessRule withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public NetworkSecurityPerimeterProfileAccessRule withType(String type) {
        this.type = type;
        return this;
    }

    private NetworkSecurityPerimeterProfileAccessRuleProperties innerProperties() {
        return this.innerProperties;
    }

    public NetworkSecurityPerimeterProfileAccessRuleDirection direction() {
        return this.innerProperties() == null ? null : this.innerProperties().direction();
    }

    public NetworkSecurityPerimeterProfileAccessRule withDirection(NetworkSecurityPerimeterProfileAccessRuleDirection direction) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityPerimeterProfileAccessRuleProperties();
        }
        this.innerProperties().withDirection(direction);
        return this;
    }

    public List<String> addressPrefixes() {
        return this.innerProperties() == null ? null : this.innerProperties().addressPrefixes();
    }

    public NetworkSecurityPerimeterProfileAccessRule withAddressPrefixes(List<String> addressPrefixes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityPerimeterProfileAccessRuleProperties();
        }
        this.innerProperties().withAddressPrefixes(addressPrefixes);
        return this;
    }

    public List<NetworkSecurityPerimeterSubscription> subscriptions() {
        return this.innerProperties() == null ? null : this.innerProperties().subscriptions();
    }

    public NetworkSecurityPerimeterProfileAccessRule withSubscriptions(List<NetworkSecurityPerimeterSubscription> subscriptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityPerimeterProfileAccessRuleProperties();
        }
        this.innerProperties().withSubscriptions(subscriptions);
        return this;
    }

    public List<NetworkSecurityPerimeterInfo> networkSecurityPerimeters() {
        return this.innerProperties() == null ? null : this.innerProperties().networkSecurityPerimeters();
    }

    public NetworkSecurityPerimeterProfileAccessRule withNetworkSecurityPerimeters(List<NetworkSecurityPerimeterInfo> networkSecurityPerimeters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityPerimeterProfileAccessRuleProperties();
        }
        this.innerProperties().withNetworkSecurityPerimeters(networkSecurityPerimeters);
        return this;
    }

    public List<String> fullyQualifiedDomainNames() {
        return this.innerProperties() == null ? null : this.innerProperties().fullyQualifiedDomainNames();
    }

    public NetworkSecurityPerimeterProfileAccessRule withFullyQualifiedDomainNames(List<String> fullyQualifiedDomainNames) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityPerimeterProfileAccessRuleProperties();
        }
        this.innerProperties().withFullyQualifiedDomainNames(fullyQualifiedDomainNames);
        return this;
    }

    public List<String> emailAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().emailAddresses();
    }

    public NetworkSecurityPerimeterProfileAccessRule withEmailAddresses(List<String> emailAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityPerimeterProfileAccessRuleProperties();
        }
        this.innerProperties().withEmailAddresses(emailAddresses);
        return this;
    }

    public List<String> phoneNumbers() {
        return this.innerProperties() == null ? null : this.innerProperties().phoneNumbers();
    }

    public NetworkSecurityPerimeterProfileAccessRule withPhoneNumbers(List<String> phoneNumbers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityPerimeterProfileAccessRuleProperties();
        }
        this.innerProperties().withPhoneNumbers(phoneNumbers);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fullyQualifiedArmId", this.fullyQualifiedArmId);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityPerimeterProfileAccessRule fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityPerimeterProfileAccessRule)jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterProfileAccessRule deserializedNetworkSecurityPerimeterProfileAccessRule = new NetworkSecurityPerimeterProfileAccessRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fullyQualifiedArmId".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterProfileAccessRule.fullyQualifiedArmId = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterProfileAccessRule.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterProfileAccessRule.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterProfileAccessRule.innerProperties = NetworkSecurityPerimeterProfileAccessRuleProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityPerimeterProfileAccessRule;
        });
    }
}

