/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.NetworkSecurityPerimeterConfigurationIssuesProperties;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterConfigurationIssueSeverity;
import com.azure.resourcemanager.eventgrid.models.NetworkSecurityPerimeterConfigurationIssueType;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityPerimeterConfigurationIssues
implements JsonSerializable<NetworkSecurityPerimeterConfigurationIssues> {
    private String name;
    private NetworkSecurityPerimeterConfigurationIssuesProperties innerProperties;

    public String name() {
        return this.name;
    }

    public NetworkSecurityPerimeterConfigurationIssues withName(String name) {
        this.name = name;
        return this;
    }

    private NetworkSecurityPerimeterConfigurationIssuesProperties innerProperties() {
        return this.innerProperties;
    }

    public NetworkSecurityPerimeterConfigurationIssueType issueType() {
        return this.innerProperties() == null ? null : this.innerProperties().issueType();
    }

    public NetworkSecurityPerimeterConfigurationIssues withIssueType(NetworkSecurityPerimeterConfigurationIssueType issueType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityPerimeterConfigurationIssuesProperties();
        }
        this.innerProperties().withIssueType(issueType);
        return this;
    }

    public NetworkSecurityPerimeterConfigurationIssueSeverity severity() {
        return this.innerProperties() == null ? null : this.innerProperties().severity();
    }

    public NetworkSecurityPerimeterConfigurationIssues withSeverity(NetworkSecurityPerimeterConfigurationIssueSeverity severity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityPerimeterConfigurationIssuesProperties();
        }
        this.innerProperties().withSeverity(severity);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public NetworkSecurityPerimeterConfigurationIssues withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityPerimeterConfigurationIssuesProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public List<String> suggestedResourceIds() {
        return this.innerProperties() == null ? null : this.innerProperties().suggestedResourceIds();
    }

    public NetworkSecurityPerimeterConfigurationIssues withSuggestedResourceIds(List<String> suggestedResourceIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityPerimeterConfigurationIssuesProperties();
        }
        this.innerProperties().withSuggestedResourceIds(suggestedResourceIds);
        return this;
    }

    public List<String> suggestedAccessRules() {
        return this.innerProperties() == null ? null : this.innerProperties().suggestedAccessRules();
    }

    public NetworkSecurityPerimeterConfigurationIssues withSuggestedAccessRules(List<String> suggestedAccessRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityPerimeterConfigurationIssuesProperties();
        }
        this.innerProperties().withSuggestedAccessRules(suggestedAccessRules);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityPerimeterConfigurationIssues fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityPerimeterConfigurationIssues)jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfigurationIssues deserializedNetworkSecurityPerimeterConfigurationIssues = new NetworkSecurityPerimeterConfigurationIssues();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationIssues.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationIssues.innerProperties = NetworkSecurityPerimeterConfigurationIssuesProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityPerimeterConfigurationIssues;
        });
    }
}

