/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.NamespaceUpdateParameterProperties;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.NamespaceSku;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.UpdateTopicSpacesConfigurationInfo;
import com.azure.resourcemanager.eventgrid.models.UpdateTopicsConfigurationInfo;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class NamespaceUpdateParameters
implements JsonSerializable<NamespaceUpdateParameters> {
    private Map<String, String> tags;
    private IdentityInfo identity;
    private NamespaceSku sku;
    private NamespaceUpdateParameterProperties innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public NamespaceUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public IdentityInfo identity() {
        return this.identity;
    }

    public NamespaceUpdateParameters withIdentity(IdentityInfo identity) {
        this.identity = identity;
        return this;
    }

    public NamespaceSku sku() {
        return this.sku;
    }

    public NamespaceUpdateParameters withSku(NamespaceSku sku) {
        this.sku = sku;
        return this;
    }

    private NamespaceUpdateParameterProperties innerProperties() {
        return this.innerProperties;
    }

    public UpdateTopicSpacesConfigurationInfo topicSpacesConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().topicSpacesConfiguration();
    }

    public NamespaceUpdateParameters withTopicSpacesConfiguration(UpdateTopicSpacesConfigurationInfo topicSpacesConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamespaceUpdateParameterProperties();
        }
        this.innerProperties().withTopicSpacesConfiguration(topicSpacesConfiguration);
        return this;
    }

    public UpdateTopicsConfigurationInfo topicsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().topicsConfiguration();
    }

    public NamespaceUpdateParameters withTopicsConfiguration(UpdateTopicsConfigurationInfo topicsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamespaceUpdateParameterProperties();
        }
        this.innerProperties().withTopicsConfiguration(topicsConfiguration);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public NamespaceUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamespaceUpdateParameterProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public List<InboundIpRule> inboundIpRules() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundIpRules();
    }

    public NamespaceUpdateParameters withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamespaceUpdateParameterProperties();
        }
        this.innerProperties().withInboundIpRules(inboundIpRules);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NamespaceUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (NamespaceUpdateParameters)jsonReader.readObject(reader -> {
            NamespaceUpdateParameters deserializedNamespaceUpdateParameters = new NamespaceUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedNamespaceUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedNamespaceUpdateParameters.identity = IdentityInfo.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedNamespaceUpdateParameters.sku = NamespaceSku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNamespaceUpdateParameters.innerProperties = NamespaceUpdateParameterProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNamespaceUpdateParameters;
        });
    }
}

