/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.NamespaceTopicEventSubscriptionDestinationProperties;
import com.azure.resourcemanager.eventgrid.models.EndpointType;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionDestination;
import java.io.IOException;

public final class NamespaceTopicEventSubscriptionDestination
extends EventSubscriptionDestination {
    private EndpointType endpointType = EndpointType.NAMESPACE_TOPIC;
    private NamespaceTopicEventSubscriptionDestinationProperties innerProperties;

    @Override
    public EndpointType endpointType() {
        return this.endpointType;
    }

    NamespaceTopicEventSubscriptionDestinationProperties innerProperties() {
        return this.innerProperties;
    }

    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    public NamespaceTopicEventSubscriptionDestination withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamespaceTopicEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NamespaceTopicEventSubscriptionDestination fromJson(JsonReader jsonReader) throws IOException {
        return (NamespaceTopicEventSubscriptionDestination)jsonReader.readObject(reader -> {
            NamespaceTopicEventSubscriptionDestination deserializedNamespaceTopicEventSubscriptionDestination = new NamespaceTopicEventSubscriptionDestination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpointType".equals(fieldName)) {
                    deserializedNamespaceTopicEventSubscriptionDestination.endpointType = EndpointType.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNamespaceTopicEventSubscriptionDestination.innerProperties = NamespaceTopicEventSubscriptionDestinationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNamespaceTopicEventSubscriptionDestination;
        });
    }
}

