/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.SkuName;
import java.io.IOException;

public final class NamespaceSku
implements JsonSerializable<NamespaceSku> {
    private SkuName name;
    private Integer capacity;

    public SkuName name() {
        return this.name;
    }

    public NamespaceSku withName(SkuName name) {
        this.name = name;
        return this;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public NamespaceSku withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeNumberField("capacity", (Number)this.capacity);
        return jsonWriter.writeEndObject();
    }

    public static NamespaceSku fromJson(JsonReader jsonReader) throws IOException {
        return (NamespaceSku)jsonReader.readObject(reader -> {
            NamespaceSku deserializedNamespaceSku = new NamespaceSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNamespaceSku.name = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedNamespaceSku.capacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNamespaceSku;
        });
    }
}

