/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.fluent.models.NamespaceInner;
import com.azure.resourcemanager.eventgrid.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.eventgrid.models.CustomDomainOwnershipValidationResult;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.NamespaceProvisioningState;
import com.azure.resourcemanager.eventgrid.models.NamespaceRegenerateKeyRequest;
import com.azure.resourcemanager.eventgrid.models.NamespaceSharedAccessKeys;
import com.azure.resourcemanager.eventgrid.models.NamespaceSku;
import com.azure.resourcemanager.eventgrid.models.PrivateEndpointConnection;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import com.azure.resourcemanager.eventgrid.models.TopicSpacesConfiguration;
import com.azure.resourcemanager.eventgrid.models.TopicsConfiguration;
import com.azure.resourcemanager.eventgrid.models.UpdateTopicSpacesConfigurationInfo;
import com.azure.resourcemanager.eventgrid.models.UpdateTopicsConfigurationInfo;
import java.util.List;
import java.util.Map;

public interface Namespace {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public NamespaceSku sku();

    public IdentityInfo identity();

    public SystemData systemData();

    public List<PrivateEndpointConnection> privateEndpointConnections();

    public NamespaceProvisioningState provisioningState();

    public TopicsConfiguration topicsConfiguration();

    public TopicSpacesConfiguration topicSpacesConfiguration();

    public Boolean isZoneRedundant();

    public PublicNetworkAccess publicNetworkAccess();

    public List<InboundIpRule> inboundIpRules();

    public TlsVersion minimumTlsVersionAllowed();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public NamespaceInner innerModel();

    public Update update();

    public Namespace refresh();

    public Namespace refresh(Context var1);

    public Response<NamespaceSharedAccessKeys> listSharedAccessKeysWithResponse(Context var1);

    public NamespaceSharedAccessKeys listSharedAccessKeys();

    public NamespaceSharedAccessKeys regenerateKey(NamespaceRegenerateKeyRequest var1);

    public NamespaceSharedAccessKeys regenerateKey(NamespaceRegenerateKeyRequest var1, Context var2);

    public CustomDomainOwnershipValidationResult validateCustomDomainOwnership();

    public CustomDomainOwnershipValidationResult validateCustomDomainOwnership(Context var1);

    public static interface UpdateStages {

        public static interface WithInboundIpRules {
            public Update withInboundIpRules(List<InboundIpRule> var1);
        }

        public static interface WithPublicNetworkAccess {
            public Update withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithTopicsConfiguration {
            public Update withTopicsConfiguration(UpdateTopicsConfigurationInfo var1);
        }

        public static interface WithTopicSpacesConfiguration {
            public Update withTopicSpacesConfiguration(UpdateTopicSpacesConfigurationInfo var1);
        }

        public static interface WithSku {
            public Update withSku(NamespaceSku var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(IdentityInfo var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithSku,
    UpdateStages.WithTopicSpacesConfiguration,
    UpdateStages.WithTopicsConfiguration,
    UpdateStages.WithPublicNetworkAccess,
    UpdateStages.WithInboundIpRules {
        public Namespace apply();

        public Namespace apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithMinimumTlsVersionAllowed {
            public WithCreate withMinimumTlsVersionAllowed(TlsVersion var1);
        }

        public static interface WithInboundIpRules {
            public WithCreate withInboundIpRules(List<InboundIpRule> var1);
        }

        public static interface WithPublicNetworkAccess {
            public WithCreate withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithIsZoneRedundant {
            public WithCreate withIsZoneRedundant(Boolean var1);
        }

        public static interface WithTopicSpacesConfiguration {
            public WithCreate withTopicSpacesConfiguration(TopicSpacesConfiguration var1);
        }

        public static interface WithTopicsConfiguration {
            public WithCreate withTopicsConfiguration(TopicsConfiguration var1);
        }

        public static interface WithPrivateEndpointConnections {
            public WithCreate withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(IdentityInfo var1);
        }

        public static interface WithSku {
            public WithCreate withSku(NamespaceSku var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithSku,
        WithIdentity,
        WithPrivateEndpointConnections,
        WithTopicsConfiguration,
        WithTopicSpacesConfiguration,
        WithIsZoneRedundant,
        WithPublicNetworkAccess,
        WithInboundIpRules,
        WithMinimumTlsVersionAllowed {
            public Namespace create();

            public Namespace create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

