/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.MonitorAlertEventSubscriptionDestinationProperties;
import com.azure.resourcemanager.eventgrid.models.EndpointType;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.MonitorAlertSeverity;
import java.io.IOException;
import java.util.List;

public final class MonitorAlertEventSubscriptionDestination
extends EventSubscriptionDestination {
    private EndpointType endpointType = EndpointType.MONITOR_ALERT;
    private MonitorAlertEventSubscriptionDestinationProperties innerProperties;

    @Override
    public EndpointType endpointType() {
        return this.endpointType;
    }

    MonitorAlertEventSubscriptionDestinationProperties innerProperties() {
        return this.innerProperties;
    }

    public MonitorAlertSeverity severity() {
        return this.innerProperties() == null ? null : this.innerProperties().severity();
    }

    public MonitorAlertEventSubscriptionDestination withSeverity(MonitorAlertSeverity severity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MonitorAlertEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withSeverity(severity);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public MonitorAlertEventSubscriptionDestination withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MonitorAlertEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public List<String> actionGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().actionGroups();
    }

    public MonitorAlertEventSubscriptionDestination withActionGroups(List<String> actionGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MonitorAlertEventSubscriptionDestinationProperties();
        }
        this.innerProperties().withActionGroups(actionGroups);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MonitorAlertEventSubscriptionDestination fromJson(JsonReader jsonReader) throws IOException {
        return (MonitorAlertEventSubscriptionDestination)jsonReader.readObject(reader -> {
            MonitorAlertEventSubscriptionDestination deserializedMonitorAlertEventSubscriptionDestination = new MonitorAlertEventSubscriptionDestination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpointType".equals(fieldName)) {
                    deserializedMonitorAlertEventSubscriptionDestination.endpointType = EndpointType.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMonitorAlertEventSubscriptionDestination.innerProperties = MonitorAlertEventSubscriptionDestinationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMonitorAlertEventSubscriptionDestination;
        });
    }
}

