/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.JsonInputSchemaMappingProperties;
import com.azure.resourcemanager.eventgrid.models.InputSchemaMapping;
import com.azure.resourcemanager.eventgrid.models.InputSchemaMappingType;
import com.azure.resourcemanager.eventgrid.models.JsonField;
import com.azure.resourcemanager.eventgrid.models.JsonFieldWithDefault;
import java.io.IOException;

public final class JsonInputSchemaMapping
extends InputSchemaMapping {
    private InputSchemaMappingType inputSchemaMappingType = InputSchemaMappingType.JSON;
    private JsonInputSchemaMappingProperties innerProperties;

    @Override
    public InputSchemaMappingType inputSchemaMappingType() {
        return this.inputSchemaMappingType;
    }

    JsonInputSchemaMappingProperties innerProperties() {
        return this.innerProperties;
    }

    public JsonField id() {
        return this.innerProperties() == null ? null : this.innerProperties().id();
    }

    public JsonInputSchemaMapping withId(JsonField id) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JsonInputSchemaMappingProperties();
        }
        this.innerProperties().withId(id);
        return this;
    }

    public JsonField topic() {
        return this.innerProperties() == null ? null : this.innerProperties().topic();
    }

    public JsonInputSchemaMapping withTopic(JsonField topic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JsonInputSchemaMappingProperties();
        }
        this.innerProperties().withTopic(topic);
        return this;
    }

    public JsonField eventTime() {
        return this.innerProperties() == null ? null : this.innerProperties().eventTime();
    }

    public JsonInputSchemaMapping withEventTime(JsonField eventTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JsonInputSchemaMappingProperties();
        }
        this.innerProperties().withEventTime(eventTime);
        return this;
    }

    public JsonFieldWithDefault eventType() {
        return this.innerProperties() == null ? null : this.innerProperties().eventType();
    }

    public JsonInputSchemaMapping withEventType(JsonFieldWithDefault eventType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JsonInputSchemaMappingProperties();
        }
        this.innerProperties().withEventType(eventType);
        return this;
    }

    public JsonFieldWithDefault subject() {
        return this.innerProperties() == null ? null : this.innerProperties().subject();
    }

    public JsonInputSchemaMapping withSubject(JsonFieldWithDefault subject) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JsonInputSchemaMappingProperties();
        }
        this.innerProperties().withSubject(subject);
        return this;
    }

    public JsonFieldWithDefault dataVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().dataVersion();
    }

    public JsonInputSchemaMapping withDataVersion(JsonFieldWithDefault dataVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JsonInputSchemaMappingProperties();
        }
        this.innerProperties().withDataVersion(dataVersion);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("inputSchemaMappingType", this.inputSchemaMappingType == null ? null : this.inputSchemaMappingType.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static JsonInputSchemaMapping fromJson(JsonReader jsonReader) throws IOException {
        return (JsonInputSchemaMapping)jsonReader.readObject(reader -> {
            JsonInputSchemaMapping deserializedJsonInputSchemaMapping = new JsonInputSchemaMapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("inputSchemaMappingType".equals(fieldName)) {
                    deserializedJsonInputSchemaMapping.inputSchemaMappingType = InputSchemaMappingType.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedJsonInputSchemaMapping.innerProperties = JsonInputSchemaMappingProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJsonInputSchemaMapping;
        });
    }
}

