/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.Filter;
import com.azure.resourcemanager.eventgrid.models.FilterOperatorType;
import java.io.IOException;

public final class IsNotNullFilter
extends Filter {
    private FilterOperatorType operatorType = FilterOperatorType.IS_NOT_NULL;

    @Override
    public FilterOperatorType operatorType() {
        return this.operatorType;
    }

    @Override
    public IsNotNullFilter withKey(String key) {
        super.withKey(key);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key());
        jsonWriter.writeStringField("operatorType", this.operatorType == null ? null : this.operatorType.toString());
        return jsonWriter.writeEndObject();
    }

    public static IsNotNullFilter fromJson(JsonReader jsonReader) throws IOException {
        return (IsNotNullFilter)jsonReader.readObject(reader -> {
            IsNotNullFilter deserializedIsNotNullFilter = new IsNotNullFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedIsNotNullFilter.withKey(reader.getString());
                    continue;
                }
                if ("operatorType".equals(fieldName)) {
                    deserializedIsNotNullFilter.operatorType = FilterOperatorType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIsNotNullFilter;
        });
    }
}

