/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.fluent.models.EventSubscriptionInner;
import com.azure.resourcemanager.eventgrid.models.DeadLetterDestination;
import com.azure.resourcemanager.eventgrid.models.DeadLetterWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeListResult;
import com.azure.resourcemanager.eventgrid.models.DeliveryWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.EventDeliverySchema;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionFilter;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionFullUrl;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionProvisioningState;
import com.azure.resourcemanager.eventgrid.models.RetryPolicy;
import java.time.OffsetDateTime;
import java.util.List;

public interface EventSubscription {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public String topic();

    public EventSubscriptionProvisioningState provisioningState();

    public EventSubscriptionDestination destination();

    public DeliveryWithResourceIdentity deliveryWithResourceIdentity();

    public EventSubscriptionFilter filter();

    public List<String> labels();

    public OffsetDateTime expirationTimeUtc();

    public EventDeliverySchema eventDeliverySchema();

    public RetryPolicy retryPolicy();

    public DeadLetterDestination deadLetterDestination();

    public DeadLetterWithResourceIdentity deadLetterWithResourceIdentity();

    public EventSubscriptionInner innerModel();

    public Update update();

    public EventSubscription refresh();

    public EventSubscription refresh(Context var1);

    public Response<DeliveryAttributeListResult> getDeliveryAttributesWithResponse(Context var1);

    public DeliveryAttributeListResult getDeliveryAttributes();

    public Response<EventSubscriptionFullUrl> getFullUrlWithResponse(Context var1);

    public EventSubscriptionFullUrl getFullUrl();

    public static interface UpdateStages {

        public static interface WithDeadLetterWithResourceIdentity {
            public Update withDeadLetterWithResourceIdentity(DeadLetterWithResourceIdentity var1);
        }

        public static interface WithDeadLetterDestination {
            public Update withDeadLetterDestination(DeadLetterDestination var1);
        }

        public static interface WithRetryPolicy {
            public Update withRetryPolicy(RetryPolicy var1);
        }

        public static interface WithEventDeliverySchema {
            public Update withEventDeliverySchema(EventDeliverySchema var1);
        }

        public static interface WithExpirationTimeUtc {
            public Update withExpirationTimeUtc(OffsetDateTime var1);
        }

        public static interface WithLabels {
            public Update withLabels(List<String> var1);
        }

        public static interface WithFilter {
            public Update withFilter(EventSubscriptionFilter var1);
        }

        public static interface WithDeliveryWithResourceIdentity {
            public Update withDeliveryWithResourceIdentity(DeliveryWithResourceIdentity var1);
        }

        public static interface WithDestination {
            public Update withDestination(EventSubscriptionDestination var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithDestination,
    UpdateStages.WithDeliveryWithResourceIdentity,
    UpdateStages.WithFilter,
    UpdateStages.WithLabels,
    UpdateStages.WithExpirationTimeUtc,
    UpdateStages.WithEventDeliverySchema,
    UpdateStages.WithRetryPolicy,
    UpdateStages.WithDeadLetterDestination,
    UpdateStages.WithDeadLetterWithResourceIdentity {
        public EventSubscription apply();

        public EventSubscription apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDeadLetterWithResourceIdentity {
            public WithCreate withDeadLetterWithResourceIdentity(DeadLetterWithResourceIdentity var1);
        }

        public static interface WithDeadLetterDestination {
            public WithCreate withDeadLetterDestination(DeadLetterDestination var1);
        }

        public static interface WithRetryPolicy {
            public WithCreate withRetryPolicy(RetryPolicy var1);
        }

        public static interface WithEventDeliverySchema {
            public WithCreate withEventDeliverySchema(EventDeliverySchema var1);
        }

        public static interface WithExpirationTimeUtc {
            public WithCreate withExpirationTimeUtc(OffsetDateTime var1);
        }

        public static interface WithLabels {
            public WithCreate withLabels(List<String> var1);
        }

        public static interface WithFilter {
            public WithCreate withFilter(EventSubscriptionFilter var1);
        }

        public static interface WithDeliveryWithResourceIdentity {
            public WithCreate withDeliveryWithResourceIdentity(DeliveryWithResourceIdentity var1);
        }

        public static interface WithDestination {
            public WithCreate withDestination(EventSubscriptionDestination var1);
        }

        public static interface WithCreate
        extends WithDestination,
        WithDeliveryWithResourceIdentity,
        WithFilter,
        WithLabels,
        WithExpirationTimeUtc,
        WithEventDeliverySchema,
        WithRetryPolicy,
        WithDeadLetterDestination,
        WithDeadLetterWithResourceIdentity {
            public EventSubscription create();

            public EventSubscription create(Context var1);
        }

        public static interface WithScope {
            public WithCreate withExistingScope(String var1);
        }

        public static interface Blank
        extends WithScope {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithScope,
    DefinitionStages.WithCreate {
    }
}

