/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.DynamicDeliveryAttributeMappingProperties;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeMapping;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeMappingType;
import java.io.IOException;

public final class DynamicDeliveryAttributeMapping
extends DeliveryAttributeMapping {
    private DeliveryAttributeMappingType type = DeliveryAttributeMappingType.DYNAMIC;
    private DynamicDeliveryAttributeMappingProperties innerProperties;

    @Override
    public DeliveryAttributeMappingType type() {
        return this.type;
    }

    DynamicDeliveryAttributeMappingProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public DynamicDeliveryAttributeMapping withName(String name) {
        super.withName(name);
        return this;
    }

    public String sourceField() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceField();
    }

    public DynamicDeliveryAttributeMapping withSourceField(String sourceField) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DynamicDeliveryAttributeMappingProperties();
        }
        this.innerProperties().withSourceField(sourceField);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DynamicDeliveryAttributeMapping fromJson(JsonReader jsonReader) throws IOException {
        return (DynamicDeliveryAttributeMapping)jsonReader.readObject(reader -> {
            DynamicDeliveryAttributeMapping deserializedDynamicDeliveryAttributeMapping = new DynamicDeliveryAttributeMapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDynamicDeliveryAttributeMapping.withName(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDynamicDeliveryAttributeMapping.type = DeliveryAttributeMappingType.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDynamicDeliveryAttributeMapping.innerProperties = DynamicDeliveryAttributeMappingProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDynamicDeliveryAttributeMapping;
        });
    }
}

