/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DeliveryMode;
import com.azure.resourcemanager.eventgrid.models.PushInfo;
import com.azure.resourcemanager.eventgrid.models.QueueInfo;
import java.io.IOException;

public final class DeliveryConfiguration
implements JsonSerializable<DeliveryConfiguration> {
    private DeliveryMode deliveryMode;
    private QueueInfo queue;
    private PushInfo push;

    public DeliveryMode deliveryMode() {
        return this.deliveryMode;
    }

    public DeliveryConfiguration withDeliveryMode(DeliveryMode deliveryMode) {
        this.deliveryMode = deliveryMode;
        return this;
    }

    public QueueInfo queue() {
        return this.queue;
    }

    public DeliveryConfiguration withQueue(QueueInfo queue) {
        this.queue = queue;
        return this;
    }

    public PushInfo push() {
        return this.push;
    }

    public DeliveryConfiguration withPush(PushInfo push) {
        this.push = push;
        return this;
    }

    public void validate() {
        if (this.queue() != null) {
            this.queue().validate();
        }
        if (this.push() != null) {
            this.push().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deliveryMode", this.deliveryMode == null ? null : this.deliveryMode.toString());
        jsonWriter.writeJsonField("queue", (JsonSerializable)this.queue);
        jsonWriter.writeJsonField("push", (JsonSerializable)this.push);
        return jsonWriter.writeEndObject();
    }

    public static DeliveryConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (DeliveryConfiguration)jsonReader.readObject(reader -> {
            DeliveryConfiguration deserializedDeliveryConfiguration = new DeliveryConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deliveryMode".equals(fieldName)) {
                    deserializedDeliveryConfiguration.deliveryMode = DeliveryMode.fromString(reader.getString());
                    continue;
                }
                if ("queue".equals(fieldName)) {
                    deserializedDeliveryConfiguration.queue = QueueInfo.fromJson(reader);
                    continue;
                }
                if ("push".equals(fieldName)) {
                    deserializedDeliveryConfiguration.push = PushInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeliveryConfiguration;
        });
    }
}

