/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.CustomWebhookAuthenticationManagedIdentityType;
import java.io.IOException;

public final class CustomWebhookAuthenticationManagedIdentity
implements JsonSerializable<CustomWebhookAuthenticationManagedIdentity> {
    private CustomWebhookAuthenticationManagedIdentityType type;
    private String userAssignedIdentity;
    private static final ClientLogger LOGGER = new ClientLogger(CustomWebhookAuthenticationManagedIdentity.class);

    public CustomWebhookAuthenticationManagedIdentityType type() {
        return this.type;
    }

    public CustomWebhookAuthenticationManagedIdentity withType(CustomWebhookAuthenticationManagedIdentityType type) {
        this.type = type;
        return this;
    }

    public String userAssignedIdentity() {
        return this.userAssignedIdentity;
    }

    public CustomWebhookAuthenticationManagedIdentity withUserAssignedIdentity(String userAssignedIdentity) {
        this.userAssignedIdentity = userAssignedIdentity;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model CustomWebhookAuthenticationManagedIdentity"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("userAssignedIdentity", this.userAssignedIdentity);
        return jsonWriter.writeEndObject();
    }

    public static CustomWebhookAuthenticationManagedIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (CustomWebhookAuthenticationManagedIdentity)jsonReader.readObject(reader -> {
            CustomWebhookAuthenticationManagedIdentity deserializedCustomWebhookAuthenticationManagedIdentity = new CustomWebhookAuthenticationManagedIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedCustomWebhookAuthenticationManagedIdentity.type = CustomWebhookAuthenticationManagedIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("userAssignedIdentity".equals(fieldName)) {
                    deserializedCustomWebhookAuthenticationManagedIdentity.userAssignedIdentity = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomWebhookAuthenticationManagedIdentity;
        });
    }
}

